---
generated_at: 2026-01-30 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-genmoduleindex.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/genmoduleindex.sh` - メインソースコード（43行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行36）
- E-03: スクリプト内Usage出力（行8）
- E-04: スクリプト内printIdAsBinary関数（行12-24）
- E-05: スクリプト内プラットフォーム判定（行26-35）
- E-06: スクリプト内ID抽出・変換処理（行37-42）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数が2個未満でUsage表示・終了 | E-01, E-03 (行7-9) | ○ |
| C-02 | $1はモジュールバイナリファイルパス | E-01, E-03 (行8), E-06 (行37) | ○ |
| C-03 | $2は出力ヘッダファイルパス | E-01, E-03 (行8), E-06 (行42) | ○ |
| C-04 | $3はreadelfバイナリパス（Linux用） | E-01, E-03 (行8), E-05 (行33) | ○ |
| C-05 | set -euo pipefailでエラー時即終了 | E-01 (行5) | ○ |
| C-06 | printIdAsBinary関数でバイナリリテラル変換 | E-01, E-04 (行12-24) | ○ |
| C-07 | 長さプレフィックスをバイト数で出力 | E-01, E-04 (行17) | ○ |
| C-08 | 各2桁の16進数を0xXX形式に変換 | E-01, E-04 (行20-22) | ○ |
| C-09 | uname -sでプラットフォーム判定 | E-01, E-05 (行26) | ○ |
| C-10 | DarwinでdwarfdumpとUUIDパターン使用 | E-01, E-05 (行27-30) | ○ |
| C-11 | Linuxでreadelfとパターン使用 | E-01, E-05 (行31-34) | ○ |
| C-12 | dwarfdump -uオプションでUUID抽出 | E-01, E-05 (行28-29) | ○ |
| C-13 | readelf -nオプションでBuild ID抽出 | E-01, E-05 (行32-33) | ○ |
| C-14 | 正規表現でID文字列をキャプチャ | E-01, E-06 (行38) | ○ |
| C-15 | ハイフンを除去して連続16進数に変換 | E-01, E-06 (行39 "//-/}") | ○ |
| C-16 | BASH_REMATCHでキャプチャグループ取得 | E-01, E-06 (行39) | ○ |
| C-17 | whileループでツール出力を処理 | E-01, E-06 (行37) | ○ |
| C-18 | 結果をファイルにリダイレクト出力 | E-01, E-06 (行42) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] dwarfdumpとreadelfの正規表現パターンが実際のツール出力と一致するか確認
- [ ] バイナリリテラル出力形式がC言語の配列初期化子として有効か確認
- [ ] Build IDが存在しないバイナリでの動作を確認
