---
generated_at: 2026-01-30 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-genmoduleindex.cmd バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/genmoduleindex.cmd` - メインソースコード（26行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行37）
- E-03: スクリプト内引数検証（行4-5）
- E-04: スクリプト内Usage出力（行23-24）
- E-05: スクリプト内イメージサイズ抽出（行8-11）
- E-06: スクリプト内タイムスタンプ抽出（行13-16）
- E-07: スクリプト内ヘッダ出力（行18）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | %1が空でUsage表示・終了 | E-01, E-03 (行4) | ○ |
| C-02 | %2が空でUsage表示・終了 | E-01, E-03 (行5) | ○ |
| C-03 | %1はモジュールバイナリファイルパス | E-01, E-04 (行24), E-05 (行8) | ○ |
| C-04 | %2は出力ヘッダファイルパス | E-01, E-04 (行24), E-07 (行18) | ○ |
| C-05 | dumpbin /HEADERSでPEヘッダ取得 | E-01, E-05 (行8), E-06 (行13) | ○ |
| C-06 | findstr /c:"size of image"でイメージサイズ検索 | E-01, E-05 (行8) | ○ |
| C-07 | findstr /c:"time date"でタイムスタンプ検索 | E-01, E-06 (行13) | ○ |
| C-08 | for /fで最初のトークンを取得 | E-01, E-05 (行8 "tokens=1"), E-06 (行13) | ○ |
| C-09 | 8桁へのゼロパディング（先頭にゼロ追加） | E-01, E-05 (行10), E-06 (行15) | ○ |
| C-10 | 末尾8文字を切り出し（~-8） | E-01, E-05 (行11), E-06 (行16) | ○ |
| C-11 | 長さプレフィックス0x08を出力 | E-01, E-07 (行18) | ○ |
| C-12 | タイムスタンプをリトルエンディアンで出力 | E-01, E-07 (行18 timestamp:~6,2等) | ○ |
| C-13 | イメージサイズをリトルエンディアンで出力 | E-01, E-07 (行18 imagesize:~6,2等) | ○ |
| C-14 | setlocal/endlocalで環境変数ローカル化 | E-01 (行7, 20) | ○ |
| C-15 | exit /b 0で正常終了 | E-01 (行21) | ○ |
| C-16 | exit /b 1でエラー終了 | E-01, E-04 (行25) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] dumpbin出力形式が想定と一致しているか確認
- [ ] リトルエンディアン変換が正しく実装されているか確認（バイト順序）
- [ ] ゼロパディング処理が8桁未満の値で正しく動作するか確認
