---
generated_at: 2026-01-30 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-copy_version_files.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/version/copy_version_files.sh` - メインソースコード（35行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行38）
- E-03: スクリプト内パス解決（行3-4）
- E-04: スクリプト内_version.c処理（行7-30）
- E-05: スクリプト内その他ファイル処理（行31-33）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | __VersionFolderはスクリプト配置ディレクトリ | E-01, E-03 (行3) | ○ |
| C-02 | __RepoRootはスクリプトから2階層上 | E-01, E-03 (行4) | ○ |
| C-03 | *.hおよび*.cファイルを走査 | E-01, E-04 (行6) | ○ |
| C-04 | _version.cを特別処理 | E-01, E-04 (行7) | ○ |
| C-05 | git rev-parse HEADでコミットハッシュ取得 | E-01, E-04 (行12) | ○ |
| C-06 | 取得失敗時は"N/A"を設定 | E-01, E-04 (行13) | ○ |
| C-07 | IFS=で単語分割を無効化 | E-01, E-04 (行10) | ○ |
| C-08 | sedでstatic行を置換 | E-01, E-04 (行15) | ○ |
| C-09 | 出力先はartifacts/obj/_version.c | E-01, E-04 (行16) | ○ |
| C-10 | 出力先ファイル存在時に内容を読み込み | E-01, E-04 (行19-20) | ○ |
| C-11 | プレースホルダーパターンで判定 | E-01, E-04 (行23) | ○ |
| C-12 | 存在しない場合はプレースホルダーフラグON | E-01, E-04 (行26) | ○ |
| C-13 | プレースホルダーかつ内容変更時のみ更新 | E-01, E-04 (行28-29) | ○ |
| C-14 | echoで新内容をファイル出力 | E-01, E-04 (行29) | ○ |
| C-15 | その他ファイルは存在チェック後コピー | E-01, E-05 (行31-33) | ○ |
| C-16 | cpでファイルコピー | E-01, E-05 (行32) | ○ |
| C-17 | sccsid文字列にコミットIDを埋め込み | E-01, E-04 (行14) | ○ |
| C-18 | "@(#)Version N/A @Commit:"形式 | E-01, E-04 (行14, 23) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] プレースホルダー判定パターンが実際のテンプレートと一致しているか確認
- [ ] artifacts/obj/ディレクトリが存在しない場合の動作を確認
- [ ] 正式なバージョン情報ファイルが既存の場合に上書きされないことを確認
