---
generated_at: 2026-01-30 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-eng/build.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/eng/build.ps1` (ソースコード、441行)
- E-02: `/Users/tomoka.baba/Work/runtime-main/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)
- E-03: `/Users/tomoka.baba/Work/runtime-main/eng/common/build.ps1` (委譲先スクリプト)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CmdletBindingでパラメータバインディング | E-01 (行1) | ○ |
| C-02 | x86, x64, arm, arm64, wasmをValidateSetで制限 | E-01 (行14) | ○ |
| C-03 | Debug, Release, Checkedの構成をサポート | E-01 (行6) | ○ |
| C-04 | windows, linux, osx, android, browser, wasiのOSをサポート | E-01 (行10) | ○ |
| C-05 | -vsオプションでVisual Studioを起動 | E-01 (行176-310) | ○ |
| C-06 | coreclr.slnx/corehost.slnxの自動生成 | E-01 (行185-223) | ○ |
| C-07 | アクション未指定時は-restore -buildがデフォルト | E-01 (行319-321) | ○ |
| C-08 | 構成/アーキテクチャのループでビルド | E-01 (行418-427) | ○ |
| C-09 | 失敗したビルドを$failedBuildsに記録 | E-01 (行416, 423-424) | ○ |
| C-10 | eng/common/build.ps1を呼び出す | E-01 (行422) | ○ |
| C-11 | -bootstrapオプションでブートストラップビルド | E-01 (行27, 365-414) | ○ |
| C-12 | ブートストラップ後にartifacts/bin, objを削除 | E-01 (行411-412) | ○ |
| C-13 | 複数構成/アーキテクチャはカンマ区切り | E-01 (行6, 14) | ○ |
| C-14 | -msbuildでMSBuildジェネレータを使用 | E-01 (行23, 340) | ○ |
| C-15 | Browser/WASIで-msbuildは非対応 | E-01 (行161-173) | ○ |
| C-16 | DOTNET_ROOTを設定 | E-01 (行267) | ○ |
| C-17 | VSDebugger_ValidateDotnetDebugLibSignatures=0を設定 | E-01 (行276) | ○ |
| C-18 | terminal loggerを無効化（/tl:false） | E-01 (行357) | ○ |
| C-19 | TreatWarningsAsErrors環境変数を参照 | E-01 (行352-354) | ○ |
| C-20 | -ninjaは効果がない旨を警告 | E-01 (行437-439) | ○ |
| C-21 | DOTNETSDK_ALLOW_TARGETING_PACK_CACHING=0を設定 | E-01 (行363) | ○ |
| C-22 | ブートストラップは単一構成/アーキテクチャのみ | E-01 (行384-392) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードで確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ValidateSetによる入力バリデーションが実装されている
- 0: 低リスク - PowerShellのパラメータバインディングにより型安全性が確保されている
- 1: 中リスク - ブートストラップビルドでのartifacts削除は意図しないデータ損失の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] Visual Studio起動時のソリューション検索ロジックの網羅性確認
- [ ] 複数構成/アーキテクチャビルドの並列化可能性検討
- [ ] ブートストラップビルド時のartifacts削除の影響範囲確認
- [ ] DOTNET_ROOT設定がVisual Studio以外の環境に与える影響確認
