---
generated_at: 2026-01-30 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-init-vs-env.cmd バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/init-vs-env.cmd` - メインソースコード（85行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行40）
- E-03: スクリプト内アーキテクチャ設定（行6-17）
- E-04: スクリプト内VSWhere処理（行32-41）
- E-05: スクリプト内VsDevCmd呼び出し（行45-53）
- E-06: スクリプト内vcvarsall呼び出し（行67-78）
- E-07: スクリプト内CMakePath設定（行82-84）
- E-08: スクリプト内エラー処理（行58-65）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | %1でターゲットアーキテクチャを受け取る | E-01, E-03 (行8-16) | ○ |
| C-02 | ARM64ホストでarm64_amd64/arm64_x86/arm64設定 | E-01, E-03 (行7-11) | ○ |
| C-03 | x64ホストでamd64/amd64_x86/amd64_arm64設定 | E-01, E-03 (行13-16) | ○ |
| C-04 | wasmターゲットでもarm64/amd64設定 | E-01, E-03 (行11, 16) | ○ |
| C-05 | VisualStudioVersion設定済みならVS検出スキップ | E-01 (行30) | ○ |
| C-06 | VSWhereパスは%ProgramFiles(x86)%\Microsoft Visual Studio\Installer | E-01, E-04 (行32) | ○ |
| C-07 | VSWhereに-latest -prerelease -productsオプション | E-01, E-04 (行38-39) | ○ |
| C-08 | -requires Microsoft.VisualStudio.Component.VC.Tools.x86.x64 | E-01, E-04 (行39) | ○ |
| C-09 | -property installationPathで取得 | E-01, E-04 (行39) | ○ |
| C-10 | Common7\Toolsをパスに追加 | E-01, E-04 (行40) | ○ |
| C-11 | VSCMD_START_DIRで現在ディレクトリを保持 | E-01, E-05 (行46) | ○ |
| C-12 | VsDevCmd.bat -no_logoで呼び出し | E-01, E-05 (行48) | ○ |
| C-13 | __VCBuildArch空なら正常終了 | E-01 (行69) | ○ |
| C-14 | SkipVCEnvInit設定時vcvarsallスキップ | E-01, E-06 (行74) | ○ |
| C-15 | vcvarsall.batを__VCBuildArchで呼び出し | E-01, E-06 (行75-76) | ○ |
| C-16 | vcvarsall失敗時exit /b 1 | E-01, E-06 (行77) | ○ |
| C-17 | set-cmake-path.ps1をfor /fで実行 | E-01, E-07 (行84) | ○ |
| C-18 | VSWhere未検出でVSWhereMissingエラー | E-01, E-08 (行63-65) | ○ |
| C-19 | VS未検出でVSMissingエラー | E-01, E-08 (行58-61) | ○ |
| C-20 | エラーメッセージにGitHub docs URLを含む | E-01, E-08 (行59-60) | ○ |
| C-21 | __VSCOMNTOOLSでVSパスを保持 | E-01, E-04 (行33, 40) | ○ |
| C-22 | vcvarsall.batはVCINSTALLDIR\Auxiliary\Buildに存在 | E-01, E-06 (行75) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 新しいVisual Studioバージョンでのvswhere検出が正しく動作するか確認
- [ ] ARM64 Windowsでのクロスコンパイル設定が正しいか確認
- [ ] SkipVCEnvInitの使用ケースと影響を理解しているか確認
- [ ] set-cmake-path.ps1の出力形式が期待通りか確認
