---
generated_at: 2026-01-30 12:58:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-sign-with-dac-certificate.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/native/sign-with-dac-certificate.ps1` - 行1-57（スクリプト全体）
- E-02: `eng/native/sign-with-dac-certificate.ps1` - 行2-7（パラメータ定義）
- E-03: `eng/native/sign-with-dac-certificate.ps1` - 行15（input.template.json読み込み）
- E-04: `eng/native/sign-with-dac-certificate.ps1` - 行16（SignBatches設定）
- E-05: `eng/native/sign-with-dac-certificate.ps1` - 行23（ログファイルパス生成）
- E-06: `eng/native/sign-with-dac-certificate.ps1` - 行32（ESRPクライアント実行）
- E-07: `eng/native/sign-with-dac-certificate.ps1` - 行35-36（署名検証開始）
- E-08: `eng/native/sign-with-dac-certificate.ps1` - 行37-40（署名存在チェック）
- E-09: `eng/native/sign-with-dac-certificate.ps1` - 行42-43（サブジェクト/発行者検証）
- E-10: `eng/native/sign-with-dac-certificate.ps1` - 行48-53（EKU検証）
- E-11: `eng/native/sign-with-dac-certificate.ps1` - 行55（成功メッセージ）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - 行43（バッチ一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DAC証明書でコード署名を行うスクリプトである | E-01, E-12 | ○ |
| C-02 | esrpClientパラメータが必須 | E-02 | ○ |
| C-03 | filesToSignパラメータが可変長引数 | E-02 | ○ |
| C-04 | input.template.jsonを読み込む | E-03 | ○ |
| C-05 | SignBatchesにファイルパスを設定 | E-04 | ○ |
| C-06 | 一時JSONファイルを生成 | E-04 | ○ |
| C-07 | ログファイルパスにGUIDを含む | E-05 | ○ |
| C-08 | ESRPクライアントのsignコマンドを実行 | E-06 | ○ |
| C-09 | auth.json、config.json、policy.jsonを使用 | E-06 | ○ |
| C-10 | Get-AuthenticodeSignatureで署名検証 | E-07 | ○ |
| C-11 | 署名が存在しない場合は例外 | E-08 | ○ |
| C-12 | サブジェクトが.NET DACであることを検証 | E-09 | ○ |
| C-13 | 発行者がMicrosoft Windows Code Signing PCA 2024であることを検証 | E-09 | ○ |
| C-14 | EKU OID 1.3.6.1.4.1.311.84.4.1を検証 | E-10 | ○ |
| C-15 | 検証成功時にメッセージを出力 | E-11 | ○ |
| C-16 | 出力先がartifacts/log/Release/ | E-05 | ○ |
| C-17 | JSON形式でログ出力 | E-05 | ○ |
| C-18 | UTF-8でJSONを出力 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] パラメータ定義がソースコードと一致していることを確認済み
- [x] ESRPクライアントの呼び出し方法が正確に記述されていることを確認済み
- [x] 署名検証ロジックが正確に記述されていることを確認済み
- [x] 証明書のサブジェクト・発行者・EKUがソースコードと一致していることを確認済み
