---
generated_at: 2026-01-30 13:02:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-build-rootfs.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/cross/build-rootfs.sh` - 行1-836（スクリプト全体）
- E-02: `eng/common/cross/build-rootfs.sh` - 行5-22（usage関数、サポートアーキテクチャ一覧）
- E-03: `eng/common/cross/build-rootfs.sh` - 行24-137（デフォルト値とパッケージリスト定義）
- E-04: `eng/common/cross/build-rootfs.sh` - 行140-424（引数解析ループ）
- E-05: `eng/common/cross/build-rootfs.sh` - 行498-568（Alpine構築処理）
- E-06: `eng/common/cross/build-rootfs.sh` - 行569-597（FreeBSD構築処理）
- E-07: `eng/common/cross/build-rootfs.sh` - 行598-677（illumos構築処理）
- E-08: `eng/common/cross/build-rootfs.sh` - 行678-758（Haiku構築処理）
- E-09: `eng/common/cross/build-rootfs.sh` - 行759-829（Ubuntu/Debian debootstrap処理）
- E-10: `eng/common/cross/build-rootfs.sh` - 行830-832（Tizen処理）
- E-11: `eng/common/cross/build-rootfs.sh` - 行113-132（Alpine公開鍵埋め込み）
- E-12: `eng/common/cross/build-rootfs.sh` - 行471-483（既存rootfs削除処理）
- E-13: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - 行44（バッチ一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クロスコンパイル用rootfsを構築するスクリプトである | E-01, E-13 | ○ |
| C-02 | デフォルトアーキテクチャはarm | E-03 | ○ |
| C-03 | デフォルトディストリビューションはxenial | E-03 | ○ |
| C-04 | サポートアーキテクチャにarm, arm64, armel, armv6, loongarch64, ppc64le, riscv64, s390x, x64, x86を含む | E-02, E-04 | ○ |
| C-05 | Alpine、FreeBSD、illumos、Haiku、Tizenをサポート | E-05, E-06, E-07, E-08, E-10 | ○ |
| C-06 | --skipunmountオプションがある | E-04 | ○ |
| C-07 | --skipsigcheckオプションがある | E-04 | ○ |
| C-08 | --skipemulationオプションがある | E-04 | ○ |
| C-09 | --use-mirrorオプションがある | E-04 | ○ |
| C-10 | --rootfsdirオプションがある | E-04 | ○ |
| C-11 | デフォルトrootfsパスは.tools/rootfs/{arch} | E-03 | ○ |
| C-12 | build-essentialパッケージを含む | E-03 | ○ |
| C-13 | libicu-devパッケージを含む | E-03 | ○ |
| C-14 | libunwind8-devパッケージを含む | E-03 | ○ |
| C-15 | Alpineはapk.staticでパッケージをインストール | E-05 | ○ |
| C-16 | FreeBSDはbase.txzを展開してpkgでパッケージをインストール | E-06 | ○ |
| C-17 | illumosはbinutilsとgccをソースからビルド | E-07 | ○ |
| C-18 | Haikuはhpkgパッケージを展開 | E-08 | ○ |
| C-19 | Ubuntu/Debianはdebootstrapを使用 | E-09 | ○ |
| C-20 | Tizenはtizen-build-rootfs.shを呼び出す | E-10 | ○ |
| C-21 | Alpine公開鍵がスクリプトに埋め込まれている | E-11 | ○ |
| C-22 | 既存rootfsがあれば削除する | E-12 | ○ |
| C-23 | debootstrap失敗時にdebootstrap.logを出力 | E-09 | ○ |
| C-24 | wgetまたはcurlを使用してダウンロード | E-05, E-06, E-07 | ○ |
| C-25 | --skipemulation時はinstall-debs.pyを使用 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] サポートアーキテクチャ一覧が正確であることを確認済み
- [x] サポートディストリビューション一覧が正確であることを確認済み
- [x] 各オプションがソースコードに存在することを確認済み
- [x] 各ディストリビューションの構築処理が正確に記述されていることを確認済み
- [x] パッケージリストがソースコードと一致していることを確認済み
