---
generated_at: 2026-01-30 13:06:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-build-android-rootfs.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/cross/build-android-rootfs.sh` - 行1-147（スクリプト全体）
- E-02: `eng/common/cross/build-android-rootfs.sh` - 行3-22（usage関数）
- E-03: `eng/common/cross/build-android-rootfs.sh` - 行24-28（デフォルト値定義）
- E-04: `eng/common/cross/build-android-rootfs.sh` - 行29-64（引数解析）
- E-05: `eng/common/cross/build-android-rootfs.sh` - 行66-72（NDKバージョン別パス設定）
- E-06: `eng/common/cross/build-android-rootfs.sh` - 行98-110（NDKダウンロード処理）
- E-07: `eng/common/cross/build-android-rootfs.sh` - 行112-117（LLDBダウンロード処理）
- E-08: `eng/common/cross/build-android-rootfs.sh` - 行119-137（Termuxパッケージ取得）
- E-09: `eng/common/cross/build-android-rootfs.sh` - 行139（sysrootへのコピー）
- E-10: `eng/common/cross/build-android-rootfs.sh` - 行142-143（android_platform生成）
- E-11: `eng/common/cross/build-android-rootfs.sh` - 行145-146（ビルドコマンド案内）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - 行45（バッチ一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Androidクロスコンパイル用のsysrootを構築する | E-01, E-12 | ○ |
| C-02 | デフォルトアーキテクチャはarm64 | E-03 | ○ |
| C-03 | デフォルトAPIレベルは28 | E-03 | ○ |
| C-04 | デフォルトNDKバージョンはr21 | E-03 | ○ |
| C-05 | arm64とarmをサポート | E-04 | ○ |
| C-06 | --ndkオプションでNDKバージョンを指定可能 | E-04 | ○ |
| C-07 | NDK r21/r22で-x86_64サフィックスを使用 | E-05 | ○ |
| C-08 | NDK未存在時にダウンロード | E-06 | ○ |
| C-09 | dl.google.comからNDKをダウンロード | E-06 | ○ |
| C-10 | LLDBをダウンロード | E-07 | ○ |
| C-11 | Termuxパッケージリポジトリを使用 | E-08 | ○ |
| C-12 | libicu, libandroid-glob, liblzma, krb5, opensslをダウンロード | E-08 | ○ |
| C-13 | dpkg -xでパッケージを展開 | E-08 | ○ |
| C-14 | sysrootにファイルをコピー | E-09 | ○ |
| C-15 | android_platformファイルにRIDを書き込む | E-10 | ○ |
| C-16 | ビルドコマンドを案内出力する | E-11 | ○ |
| C-17 | TOOLCHAIN_DIR環境変数で出力先を変更可能 | E-04 | ○ |
| C-18 | NDK_DIR環境変数で既存NDKを指定可能 | E-04 | ○ |
| C-19 | APIレベル28はglob(3)サポートの最低バージョン | E-03 | ○ |
| C-20 | termux-main-21リポジトリを使用 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] デフォルト値がソースコードと一致していることを確認済み
- [x] サポートアーキテクチャが正確であることを確認済み
- [x] NDKダウンロードURLが正確であることを確認済み
- [x] 依存パッケージリストが正確であることを確認済み
- [x] android_platformファイルの形式が正確であることを確認済み
