---
generated_at: 2026-01-30 13:22:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-tools.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/tools.ps1` - 行1-961（スクリプト全体）
- E-02: `eng/common/tools.ps1` - 行5-69（変数初期化とデフォルト値）
- E-03: `eng/common/tools.ps1` - 行155-228（InitializeDotNetCli関数）
- E-04: `eng/common/tools.ps1` - 行287-365（InstallDotNet関数）
- E-05: `eng/common/tools.ps1` - 行230-252（Retry関数）
- E-06: `eng/common/tools.ps1` - 行254-281（GetDotNetInstallScript関数）
- E-07: `eng/common/tools.ps1` - 行378-477（InitializeVisualStudioMSBuild関数）
- E-08: `eng/common/tools.ps1` - 行535-593（LocateVisualStudio関数）
- E-09: `eng/common/tools.ps1` - 行494-520（InitializeXCopyMSBuild関数）
- E-10: `eng/common/tools.ps1` - 行595-639（InitializeBuildTool関数）
- E-11: `eng/common/tools.ps1` - 行696-739（InitializeToolset関数）
- E-12: `eng/common/tools.ps1` - 行771-797（MSBuild関数）
- E-13: `eng/common/tools.ps1` - 行804-865（MSBuild-Core関数）
- E-14: `eng/common/tools.ps1` - 行741-757（ExitWithExitCode、Stop-Processes関数）
- E-15: `eng/common/tools.ps1` - 行909-943（初期化処理、パス解決）
- E-16: `eng/common/tools.ps1` - 行948-960（Enable-Nuget-EnhancedRetry関数）
- E-17: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - 行49（バッチ一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows向け共通ビルドツール関数を提供する | E-01, E-17 | ○ |
| C-02 | $ciのデフォルト値はfalse | E-02 | ○ |
| C-03 | $configurationのデフォルト値はDebug | E-02 | ○ |
| C-04 | $verbosityのデフォルト値はminimal | E-02 | ○ |
| C-05 | $nodeReuseはci時にfalse | E-02 | ○ |
| C-06 | $binaryLogはci時にtrue | E-02 | ○ |
| C-07 | $useGlobalNuGetCacheはci時にfalse | E-02 | ○ |
| C-08 | InitializeDotNetCli関数が存在 | E-03 | ○ |
| C-09 | DOTNET_NOLOGO=1を設定 | E-03 | ○ |
| C-10 | ci時にDOTNET_CLI_TELEMETRY_OPTOUT=1を設定 | E-03 | ○ |
| C-11 | InstallDotNet関数が存在 | E-04 | ○ |
| C-12 | Retry関数は最大5回リトライ | E-05 | ○ |
| C-13 | リトライは指数バックオフ | E-05 | ○ |
| C-14 | dotnet-install.ps1は30日経過で再ダウンロード | E-06 | ○ |
| C-15 | InitializeVisualStudioMSBuild関数が存在 | E-07 | ○ |
| C-16 | VS最低要件は17.7 | E-07 | ○ |
| C-17 | xcopy MSBuildデフォルトバージョンは18.0.0 | E-07 | ○ |
| C-18 | LocateVisualStudio関数が存在 | E-08 | ○ |
| C-19 | vswhereバージョンは3.1.7 | E-08 | ○ |
| C-20 | InitializeXCopyMSBuild関数が存在 | E-09 | ○ |
| C-21 | InitializeBuildTool関数が存在 | E-10 | ○ |
| C-22 | InitializeToolset関数が存在 | E-11 | ○ |
| C-23 | MSBuild関数がArcadeロガーを設定 | E-12 | ○ |
| C-24 | MSBuild-Core関数がCI時にバイナリログを必須化 | E-13 | ○ |
| C-25 | MSBuild-Core関数がCI時にノード再利用を禁止 | E-13 | ○ |
| C-26 | ExitWithExitCode関数が存在 | E-14 | ○ |
| C-27 | Stop-Processes関数が存在 | E-14 | ○ |
| C-28 | Enable-Nuget-EnhancedRetry関数が存在 | E-16 | ○ |
| C-29 | global.jsonを読み込む | E-15 | ○ |
| C-30 | configure-toolset.ps1を読み込む | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 変数のデフォルト値がソースコードと一致していることを確認済み
- [x] 主要関数が全てリストされていることを確認済み
- [x] InitializeDotNetCli関数の動作が正確に記述されていることを確認済み
- [x] InitializeVisualStudioMSBuild関数の動作が正確に記述されていることを確認済み
- [x] MSBuild関数のCI時制約が正確に記述されていることを確認済み
- [x] リトライ仕様がソースコードと一致していることを確認済み
