---
generated_at: 2026-01-30 13:26:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-msbuild.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/msbuild.sh` - 行1-59（スクリプト全体）
- E-02: `eng/common/msbuild.sh` - 行3-13（シンボリックリンク解決処理）
- E-03: `eng/common/msbuild.sh` - 行15-19（デフォルト値設定）
- E-04: `eng/common/msbuild.sh` - 行21-49（引数解析ループ）
- E-05: `eng/common/msbuild.sh` - 行51（tools.shのsource）
- E-06: `eng/common/msbuild.sh` - 行53-55（CI時のnode_reuse無効化）
- E-07: `eng/common/msbuild.sh` - 行57-58（MSBuild実行とExitWithExitCode）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - 行50（バッチ一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MSBuild実行ラッパースクリプトである | E-01, E-08 | ○ |
| C-02 | verbosityのデフォルト値はminimal | E-03 | ○ |
| C-03 | warn_as_errorのデフォルト値はtrue | E-03 | ○ |
| C-04 | node_reuseのデフォルト値はtrue | E-03 | ○ |
| C-05 | prepare_machineのデフォルト値はfalse | E-03 | ○ |
| C-06 | --verbosityオプションがある | E-04 | ○ |
| C-07 | --warnaserrorオプションがある | E-04 | ○ |
| C-08 | --nodereuse オプションがある | E-04 | ○ |
| C-09 | --ciオプションがある | E-04 | ○ |
| C-10 | --preparemachineオプションがある | E-04 | ○ |
| C-11 | tools.shをsourceする | E-05 | ○ |
| C-12 | CI時にnode_reuseがfalseになる | E-06 | ○ |
| C-13 | MSBuild関数を呼び出す | E-07 | ○ |
| C-14 | ExitWithExitCode 0で終了する | E-07 | ○ |
| C-15 | シンボリックリンクを解決する | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] デフォルト値がソースコードと一致していることを確認済み
- [x] サポートされるオプションが全てリストされていることを確認済み
- [x] CI時のnode_reuse無効化がソースコードと一致していることを確認済み
- [x] tools.shのsourceがソースコードと一致していることを確認済み
