---
generated_at: 2026-01-30 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-eng/common/build.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/eng/common/build.sh` (ソースコード、278行)
- E-02: `/Users/tomoka.baba/Work/runtime-main/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -u -e でエラー時停止を設定 | E-01 (行4-8) | ○ |
| C-02 | restore, build, test, pack, publishアクションをサポート | E-01 (usage関数, 行19-35) | ○ |
| C-03 | source-buildモードをサポート | E-01 (行134-140) | ○ |
| C-04 | product-buildモードをサポート | E-01 (行141-146) | ○ |
| C-05 | --cleanでartifactsディレクトリを削除 | E-01 (行265-271) | ○ |
| C-06 | tools.shを読み込む | E-01 (行214) | ○ |
| C-07 | source_build時はデフォルトでRelease構成 | E-01 (行202-204) | ○ |
| C-08 | CI時はbinary_log有効、node_reuse無効 | E-01 (行206-212) | ○ |
| C-09 | InitializeToolsetを呼び出す | E-01 (行225) | ○ |
| C-10 | InitializeCustomToolsetでeng/restore-toolset.shを読み込む | E-01 (行216-222) | ○ |
| C-11 | MSBuild関数でビルドを実行 | E-01 (行242-261) | ○ |
| C-12 | --restore時にInitializeNativeToolsを呼び出す | E-01 (行273-275) | ○ |
| C-13 | ExitWithExitCode 0で正常終了 | E-01 (行262) | ○ |
| C-14 | バイナリログはlog_dir/Build.binlogに出力 | E-01 (行233-235) | ○ |
| C-15 | /p:Configurationでビルド構成を指定 | E-01 (行245) | ○ |
| C-16 | /p:DotNetBuildでproduct_buildを指定 | E-01 (行249) | ○ |
| C-17 | /p:DotNetBuildSourceOnlyでsource_buildを指定 | E-01 (行250) | ○ |
| C-18 | --buildCheckで/checkオプションを追加 | E-01 (行237-240) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードで確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Arcadeフレームワークの標準的なビルドスクリプト
- 0: 低リスク - 入力パラメータの検証が実装されている
- 1: 中リスク - --cleanでartifactsディレクトリ全体を削除するため注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] eng/restore-toolset.shが存在しない場合の動作確認
- [ ] source-buildモードでの依存関係の完全性確認
- [ ] CI環境でのバイナリログサイズの監視
- [ ] --cleanオプション使用時の影響範囲確認
