---
generated_at: 2026-01-30 13:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-sdk-task.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdk-task.sh` - 行1-122（スクリプト全体）
- E-02: `eng/common/sdk-task.sh` - 行3-16（show_usage関数）
- E-03: `eng/common/sdk-task.sh` - 行18-28（シンボリックリンク解決処理）
- E-04: `eng/common/sdk-task.sh` - 行30-47（Build関数）
- E-05: `eng/common/sdk-task.sh` - 行49-56（デフォルト値設定）
- E-06: `eng/common/sdk-task.sh` - 行58-91（引数解析ループ）
- E-07: `eng/common/sdk-task.sh` - 行93（ci=true設定）
- E-08: `eng/common/sdk-task.sh` - 行95-98（ヘルプ表示処理）
- E-09: `eng/common/sdk-task.sh` - 行100-101（tools.shのsourceとInitializeToolset）
- E-10: `eng/common/sdk-task.sh` - 行103-106（タスク指定確認）
- E-11: `eng/common/sdk-task.sh` - 行108-112（タスクプロジェクト存在確認）
- E-12: `eng/common/sdk-task.sh` - 行114-118（Restore/Execute実行）
- E-13: `eng/common/sdk-task.sh` - 行121（ExitWithExitCode 0）
- E-14: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - 行51（バッチ一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Arcade SDKタスク実行ラッパースクリプトである | E-01, E-14 | ○ |
| C-02 | binary_logのデフォルト値はtrue | E-05 | ○ |
| C-03 | configurationのデフォルト値はDebug | E-05 | ○ |
| C-04 | verbosityのデフォルト値はminimal | E-05 | ○ |
| C-05 | restoreのデフォルト値はfalse | E-05 | ○ |
| C-06 | warnAsErrorのデフォルト値はtrue | E-05 | ○ |
| C-07 | --taskオプションがある | E-06 | ○ |
| C-08 | --restoreオプションがある | E-06 | ○ |
| C-09 | --verbosityオプションがある | E-06 | ○ |
| C-10 | --excludeCIBinarylog/--noblオプションがある | E-06 | ○ |
| C-11 | --noWarnAsErrorオプションがある | E-06 | ○ |
| C-12 | ci=trueが強制設定される | E-07 | ○ |
| C-13 | tools.shをsourceする | E-09 | ○ |
| C-14 | InitializeToolsetを呼び出す | E-09 | ○ |
| C-15 | タスク未指定でエラー終了する | E-10 | ○ |
| C-16 | GetSdkTaskProjectでプロジェクト取得する | E-11 | ○ |
| C-17 | restore=trueでRestoreターゲット実行 | E-12 | ○ |
| C-18 | Executeターゲットは常に実行される | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] デフォルト値がソースコードと一致していることを確認済み
- [x] サポートされるオプションが全てリストされていることを確認済み
- [x] ci=true強制設定がソースコードと一致していることを確認済み
- [x] Build関数の動作がソースコードと一致していることを確認済み
- [x] エラー処理（MissingTask、UnknownTask）がソースコードと一致していることを確認済み
