---
generated_at: 2026-01-30 12:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-sdk-task.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし
  2. **タスク一覧**：Arcade SDKの内部構造に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdk-task.ps1` （ソースコード）
- E-02: `eng/common/tools.ps1` （依存スクリプト）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-04: スクリプト内のParam定義（行1-15）
- E-05: スクリプト内のPrint-Usage関数（行23-37）
- E-06: スクリプト内のBuild関数（行39-53）
- E-07: スクリプト内のメイン処理ロジック（行55-103）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows環境でArcade SDKタスクを実行するスクリプト | E-01, E-03 | ○ |
| C-02 | tools.ps1に依存している | E-01 (行21) | ○ |
| C-03 | パラメータconfigurationのデフォルトはDebug | E-04 (行3) | ○ |
| C-04 | パラメータtaskは必須 | E-07 (行61-65) | ○ |
| C-05 | パラメータverbosityのデフォルトはminimal | E-04 (行6) | ○ |
| C-06 | msbuildEngineがvsの場合xcopy MSBuildを使用 | E-07 (行67-83) | ○ |
| C-07 | バイナリログはLogDirに出力される | E-06 (行41-42) | ○ |
| C-08 | GetSdkTaskProject関数でプロジェクトパス取得 | E-07 (行85) | ○ |
| C-09 | restoreオプションでRestore処理実行 | E-07 (行91-93) | ○ |
| C-10 | Executeターゲットを実行する | E-07 (行95) | ○ |
| C-11 | エラー時は終了コード1 | E-07 (行64, 89, 100-101) | ○ |
| C-12 | 成功時は終了コード0 | E-07 (行103) | ○ |
| C-13 | Write-PipelineTelemetryErrorでエラー出力 | E-07 (行62, 87, 99) | ○ |
| C-14 | ヘルプオプションで使用方法表示 | E-07 (行56-59), E-05 | ○ |
| C-15 | VS 16.5以上が必要 | E-07 (行70) | ○ |
| C-16 | xcopy-msbuild 18.0.0を使用 | E-07 (行73) | ○ |
| C-17 | 目標処理時間は数分〜数十分 | **根拠なし** | △ |
| C-18 | Arcade SDKのSdkTasksディレクトリにタスクが存在 | **根拠なし**（外部依存） | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値根拠がない
  - 候補：実際のCI/CDパイプラインログ / パフォーマンステスト結果 / SLAドキュメント
- Arcade SDKの内部構造（SdkTasksディレクトリの具体的なタスク一覧）
  - 候補：Arcade SDKのドキュメント / NuGetパッケージ内容 / arcade リポジトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義、基本的な処理フロー
- 1: 中リスク - パフォーマンス要件（実測値なし）
- 1: 中リスク - 外部依存（Arcade SDK）の詳細仕様

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ一覧がソースコードのParam定義と一致しているか確認
- [ ] エラーハンドリングの記述が実装と一致しているか確認
- [ ] Arcade SDKタスクの具体的な種類を補足する必要があるか判断
- [ ] 目標処理時間を実測値で更新する必要があるか判断
