---
generated_at: 2026-01-30 12:57:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：52-darc-init.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（1-5分）**：実測値ではなく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/darc-init.sh` （ソースコード）
- E-02: `eng/common/tools.sh` （依存スクリプト）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-04: スクリプト内の引数解析部分（行8-35）
- E-05: スクリプト内のInstallDarcCli関数（行53-80）
- E-06: スクリプト内のバージョン取得ロジック（行49-51）
- E-07: スクリプト内のデフォルト値定義（行4-6）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Linux/macOS環境でDARC CLIをインストールするスクリプト | E-01, E-03 | ○ |
| C-02 | tools.shに依存している | E-01 (行47) | ○ |
| C-03 | デフォルトのversionEndpointはMaestro API | E-07 (行5) | ○ |
| C-04 | デフォルトのverbosityはminimal | E-07 (行6) | ○ |
| C-05 | darcVersionが未指定の場合curlでAPIから取得 | E-06 (行49-51) | ○ |
| C-06 | InitializeDotNetCli関数でdotnet SDK初期化 | E-05 (行56-57) | ○ |
| C-07 | 既存DARCがあればアンインストール | E-05 (行60-68) | ○ |
| C-08 | dotnet tool installでインストール | E-05 (行76-79) | ○ |
| C-09 | Azure Artifactsのdotnet-engフィードを使用 | E-05 (行71) | ○ |
| C-10 | toolpath指定時はそのパスにインストール | E-05 (行65-68, 78-79) | ○ |
| C-11 | グローバルツールとして-gオプションでインストール | E-05 (行76-77) | ○ |
| C-12 | microsoft.dotnet.darcパッケージをインストール | E-05 (行54) | ○ |
| C-13 | シェル再起動の案内を表示 | E-05 (行74) | ○ |
| C-14 | 不正な引数でexit 1 | E-04 (行28-30) | ○ |
| C-15 | 引数は大文字小文字を区別しない | E-04 (行9) | ○ |
| C-16 | 目標処理時間は1-5分 | **根拠なし**（推定値） | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な実測値
  - 候補：CI/CDパイプラインの実行ログ / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 引数解析、インストールロジック
- 0: 低リスク - 依存関係（tools.sh）
- 1: 中リスク - パフォーマンス要件（実測値なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 引数一覧がソースコードの解析ロジックと一致しているか確認
- [ ] Azure ArtifactsフィードのURLが最新かどうか確認
- [ ] Maestro APIのエンドポイントが有効かどうか確認
- [ ] 目標処理時間を実測値で更新する必要があるか判断
