---
generated_at: 2026-01-30 12:59:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：53-darc-init.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（1-5分）**：実測値ではなく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/darc-init.ps1` （ソースコード）
- E-02: `eng/common/tools.ps1` （依存スクリプト）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-04: スクリプト内のparam定義（行1-6）
- E-05: スクリプト内のInstallDarcCli関数（行10-38）
- E-06: スクリプト内のtry-catch構造（行40-47）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows環境でDARC CLIをインストールするスクリプト | E-01, E-03 | ○ |
| C-02 | tools.ps1に依存している | E-01 (行8) | ○ |
| C-03 | デフォルトのversionEndpointはMaestro API | E-04 (行3) | ○ |
| C-04 | デフォルトのverbosityはminimal | E-04 (行4) | ○ |
| C-05 | darcVersionが$nullの場合Invoke-WebRequestでAPIから取得 | E-05 (行23-24) | ○ |
| C-06 | InitializeDotNetCli関数でdotnet SDK初期化 | E-05 (行13) | ○ |
| C-07 | 既存DARCがあればアンインストール | E-05 (行17-19) | ○ |
| C-08 | dotnet tool installでインストール | E-05 (行33, 36) | ○ |
| C-09 | Azure Artifactsのdotnet-engフィードを使用 | E-05 (行27) | ○ |
| C-10 | toolpath指定時はそのパスにインストール | E-05 (行34-37) | ○ |
| C-11 | グローバルツールとして-gオプションでインストール | E-05 (行33) | ○ |
| C-12 | microsoft.dotnet.darcパッケージをインストール | E-05 (行11) | ○ |
| C-13 | コマンドウィンドウ再起動の案内を表示 | E-05 (行30) | ○ |
| C-14 | エラー時はexit 1 | E-06 (行46) | ○ |
| C-15 | Write-PipelineTelemetryErrorでエラー出力 | E-06 (行45) | ○ |
| C-16 | 実行コマンドをWrite-Hostで出力 | E-05 (行32, 35) | ○ |
| C-17 | 目標処理時間は1-5分 | **根拠なし**（推定値） | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な実測値
  - 候補：CI/CDパイプラインの実行ログ / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義、インストールロジック
- 0: 低リスク - 依存関係（tools.ps1）
- 0: 低リスク - エラーハンドリング（try-catch構造）
- 1: 中リスク - パフォーマンス要件（実測値なし）

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ一覧がソースコードのparam定義と一致しているか確認
- [ ] Azure ArtifactsフィードのURLが最新かどうか確認
- [ ] Maestro APIのエンドポイントが有効かどうか確認
- [ ] 目標処理時間を実測値で更新する必要があるか判断
