---
generated_at: 2026-01-30 13:02:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：54-init-tools-native.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（1-10分）**：実測値ではなく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/init-tools-native.sh` （ソースコード）
- E-02: `eng/common/native/common-library.sh` （依存スクリプト）
- E-03: `eng/common/pipeline-logging-functions.sh` （依存スクリプト）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-05: スクリプト内の引数解析部分（行18-76）
- E-06: スクリプト内のReadGlobalJsonNativeTools関数（行78-162）
- E-07: スクリプト内のメインロジック（行164-236）
- E-08: スクリプト内のデフォルト値定義（行6-12）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Linux/macOS環境でネイティブビルドツールを初期化するスクリプト | E-01, E-04 | ○ |
| C-02 | pipeline-logging-functions.shとcommon-library.shに依存 | E-01 (行15-16) | ○ |
| C-03 | デフォルトのbase_uriはAzure Blob Storage | E-08 (行6) | ○ |
| C-04 | デフォルトのdownload_retriesは5 | E-08 (行10) | ○ |
| C-05 | デフォルトのretry_wait_time_secondsは30 | E-08 (行11) | ○ |
| C-06 | global.jsonからnative-toolsセクションを読み取る | E-06 | ○ |
| C-07 | jqが利用可能ならjqを使用 | E-06 (行80-96) | ○ |
| C-08 | jqがなければBashで手動パース | E-06 (行99-161) | ○ |
| C-09 | native-toolsがない場合はメッセージ出力して終了 | E-07 (行174-176) | ○ |
| C-10 | インストールディレクトリはGetNativeInstallDirectory関数で取得 | E-07 (行164-167) | ○ |
| C-11 | install-{KEY}.shを呼び出してインストール | E-07 (行182-198) | ○ |
| C-12 | --cleanオプションでクリーンアップのみ実行 | E-07 (行193-195, 224-226) | ○ |
| C-13 | --forceオプションでクリーン後インストール | E-07 (行189-191) | ○ |
| C-14 | ##vso[task.prependpath]でパス設定 | E-07 (行230) | ○ |
| C-15 | インストール先は{install_bin}ディレクトリ | E-07 (行169) | ○ |
| C-16 | donotabortonfailureでエラー時も継続 | E-07 (行200-206) | ○ |
| C-17 | donotdisplaywarningsで警告非表示 | E-07 (行201-203) | ○ |
| C-18 | Write-PipelineTelemetryErrorでエラー出力 | E-07 (行202, 205, 214, 217, 233) | ○ |
| C-19 | インストーラが存在しない場合はエラー | E-07 (行211-220) | ○ |
| C-20 | 目標処理時間は1-10分 | **根拠なし**（推定値） | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な実測値
  - 候補：CI/CDパイプラインの実行ログ / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 引数解析、基本ロジック
- 0: 低リスク - JSONパース（jq/Bashの両対応）
- 1: 中リスク - パフォーマンス要件（実測値なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 引数一覧がソースコードの解析ロジックと一致しているか確認
- [ ] global.jsonのnative-toolsセクションの形式が正しく説明されているか確認
- [ ] Azure Blob StorageのURLが最新かどうか確認
- [ ] 目標処理時間を実測値で更新する必要があるか判断
