---
generated_at: 2026-01-30 13:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：55-init-tools-native.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（1-10分）**：実測値ではなく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/init-tools-native.ps1` （ソースコード）
- E-02: `eng/common/native/CommonLibrary.psm1` （依存モジュール・参照）
- E-03: `eng/common/pipeline-logging-functions.ps1` （依存スクリプト・参照）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-05: スクリプト内のParam定義（行40-50）
- E-06: スクリプト内のPathPromotion処理（行85-128）
- E-07: スクリプト内の通常インストール処理（行129-177）
- E-08: スクリプト内のパス設定処理（行185-196）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows環境でネイティブビルドツールを初期化するスクリプト | E-01, E-04 | ○ |
| C-02 | pipeline-logging-functions.ps1とCommonLibrary.psm1に依存 | E-01 (行59-60) | ○ |
| C-03 | デフォルトのBaseUriはAzure Blob Storage | E-05 (行42) | ○ |
| C-04 | デフォルトのDownloadRetriesは5 | E-05 (行46) | ○ |
| C-05 | デフォルトのRetryWaitTimeInSecondsは30 | E-05 (行47) | ○ |
| C-06 | global.jsonからnative-toolsセクションを読み取る | E-01 (行81-83) | ○ |
| C-07 | PathPromotion有効時はarcade-toolsディレクトリを確認 | E-06 (行86-87) | ○ |
| C-08 | arcade-toolsはC:\arcade-tools | E-06 (行86) | ○ |
| C-09 | binpath.txtからパス情報を取得 | E-06 (行103-108) | ○ |
| C-10 | ##vso[task.prependpath]でパス設定 | E-06 (行111), E-08 (行190) | ○ |
| C-11 | native-toolsがない場合はメッセージ出力して終了 | E-01 (行180-183) | ○ |
| C-12 | Get-NativeInstallDirectoryでインストールディレクトリ取得 | E-01 (行69) | ○ |
| C-13 | install-tool.ps1を呼び出してインストール | E-07 (行153) | ○ |
| C-14 | -Cleanオプションでクリーンアップのみ | E-07 (行147-149), E-08 (行185-187) | ○ |
| C-15 | -Forceオプションで強制インストール | E-07 (行142-146) | ○ |
| C-16 | DoNotAbortNativeToolsInstallationOnFailureで継続 | E-07 (行156-164) | ○ |
| C-17 | Write-PipelineTelemetryErrorでエラー出力 | E-06 (行123-124), E-08 (行194, 201) | ○ |
| C-18 | ツールが見つからない場合はエラー | E-06 (行99-100, 122-125) | ○ |
| C-19 | StrictModeが有効 | E-01 (行56) | ○ |
| C-20 | try-catchでエラーハンドリング | E-01 (行62, 199-203) | ○ |
| C-21 | InstallBinを返却 | E-08 (行191) | ○ |
| C-22 | 目標処理時間は1-10分 | **根拠なし**（推定値） | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な実測値
  - 候補：CI/CDパイプラインの実行ログ / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義、基本ロジック
- 0: 低リスク - PathPromotion機能の説明
- 1: 中リスク - パフォーマンス要件（実測値なし）

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ一覧がソースコードのParam定義と一致しているか確認
- [ ] global.jsonのnative-toolsセクションの形式が正しく説明されているか確認
- [ ] PathPromotion機能の動作が正確に記述されているか確認
- [ ] arcade-toolsディレクトリの構造説明が十分か確認
- [ ] 目標処理時間を実測値で更新する必要があるか判断
