---
generated_at: 2026-01-30 13:14:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-init-distro-rid.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/native/init-distro-rid.sh` （ソースコード）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-03: スクリプト内のgetNonPortableDistroRid関数（行12-58）
- E-04: スクリプト内のinitDistroRidGlobal関数（行75-110）
- E-05: スクリプト内のmusl検出ロジック（行102-106）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ディストリビューションのRIDを判定するスクリプト | E-01, E-02 | ○ |
| C-02 | getNonPortableDistroRid関数を提供 | E-03 | ○ |
| C-03 | initDistroRidGlobal関数を提供 | E-04 | ○ |
| C-04 | /etc/os-releaseからID、VERSION_IDを読み取り | E-03 (行21-30) | ○ |
| C-05 | VERSION_IDがバージョン形式かチェック | E-03 (行23) | ○ |
| C-06 | ローリングリリースはVERSION_ID省略 | E-03 (行24-30) | ○ |
| C-07 | android_platformファイルからRID取得 | E-03 (行31-35) | ○ |
| C-08 | FreeBSDはfreebsd-versionを使用 | E-03 (行38-41) | ○ |
| C-09 | Androidはgetpropを使用 | E-03 (行42-44) | ○ |
| C-10 | illumosはillumos-archの形式 | E-03 (行45-47) | ○ |
| C-11 | Solarisはsolaris.major-archの形式 | E-03 (行48-51) | ○ |
| C-12 | Haikuはhaiku.rN-archの形式 | E-03 (行52-55) | ○ |
| C-13 | 小文字に正規化 | E-03 (行57) | ○ |
| C-14 | rootfsDirの存在確認 | E-04 (行84-90) | ○ |
| C-15 | rootfsDir不在時エラーexit 1 | E-04 (行87-89) | ○ |
| C-16 | __DistroRidを設定 | E-04 (行92) | ○ |
| C-17 | __PortableTargetOSをtargetOsで初期化 | E-04 (行94-95) | ○ |
| C-18 | lddでmusl検出 | E-05 (行103) | ○ |
| C-19 | stringsでmusl検出（バックアップ） | E-05 (行104) | ○ |
| C-20 | musl時はlinux-muslに設定 | E-05 (行105) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RID生成ロジック
- 0: 低リスク - musl検出ロジック
- 0: 低リスク - エラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] RID形式の例が実際の出力と一致しているか確認
- [ ] 各プラットフォームの処理が正しく説明されているか確認
- [ ] musl検出のフォールバック（strings）が適切に説明されているか確認
- [ ] クロスコンパイル時のrootfsDir使用が正しく説明されているか確認
