---
generated_at: 2026-01-30 13:17:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-common-library.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/native/common-library.sh` （ソースコード）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-03: スクリプト内のGetNativeInstallDirectory関数（行3-14）
- E-04: スクリプト内のGetTempDirectory関数（行16-20）
- E-05: スクリプト内のExpandZip関数（行22-53）
- E-06: スクリプト内のGetCurrentOS関数（行55-62）
- E-07: スクリプト内のGetFile関数（行64-95）
- E-08: スクリプト内のGetTempPathFileName関数（行97-104）
- E-09: スクリプト内のDownloadAndExtract関数（行106-133）
- E-10: スクリプト内のNewScriptShim関数（行135-171）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 共通ライブラリ関数を提供するスクリプト | E-01, E-02 | ○ |
| C-02 | GetNativeInstallDirectory関数を提供 | E-03 | ○ |
| C-03 | NETCOREENG_INSTALL_DIRECTORYを参照 | E-03 (行6) | ○ |
| C-04 | デフォルトは$HOME/.netcoreeng/native/ | E-03 (行7) | ○ |
| C-05 | GetTempDirectory関数を提供 | E-04 | ○ |
| C-06 | ExpandZip関数を提供 | E-05 | ○ |
| C-07 | force引数でディレクトリ削除 | E-05 (行33-39) | ○ |
| C-08 | tar -xfで展開 | E-05 (行46) | ○ |
| C-09 | GetCurrentOS関数を提供 | E-06 | ○ |
| C-10 | Linux/MacOSを返す | E-06 (行58-59) | ○ |
| C-11 | GetFile関数を提供 | E-07 | ○ |
| C-12 | curlを優先使用 | E-07 (行88) | ○ |
| C-13 | curlがなければwget | E-07 (行91) | ○ |
| C-14 | リトライ設定をサポート | E-07 (行68-69, 89, 91) | ○ |
| C-15 | ローカルファイルはコピー | E-07 (行80-83) | ○ |
| C-16 | GetTempPathFileName関数を提供 | E-08 | ○ |
| C-17 | DownloadAndExtract関数を提供 | E-09 | ○ |
| C-18 | GetFileとExpandZipを呼び出す | E-09 (行118, 126) | ○ |
| C-19 | NewScriptShim関数を提供 | E-10 | ○ |
| C-20 | 小文字パスもチェック | E-10 (行152) | ○ |
| C-21 | chmod +xで実行可能にする | E-10 (行166) | ○ |
| C-22 | Write-PipelineTelemetryErrorでエラー出力 | E-05 (行37, 48), E-07等 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 各関数の定義と引数
- 0: 低リスク - ダウンロード・展開ロジック
- 0: 低リスク - シム生成ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] 提供関数一覧がソースコードと一致しているか確認
- [ ] 各関数の引数と戻り値が正しく記述されているか確認
- [ ] エラーハンドリングが適切に説明されているか確認
- [ ] リトライ仕様が正しく記述されているか確認
