---
generated_at: 2026-01-30 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-eng/common/build.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/eng/common/build.ps1` (ソースコード、179行)
- E-02: `/Users/tomoka.baba/Work/runtime-main/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Platform環境変数をクリア | E-01 (行38-41) | ○ |
| C-02 | tools.ps1を読み込む | E-01 (行85) | ○ |
| C-03 | -cleanで$ArtifactsDirを削除 | E-01 (行143-149) | ○ |
| C-04 | -helpでPrint-Usageを呼び出す | E-01 (行151-154) | ○ |
| C-05 | CI時はbinaryLog有効、nodeReuse無効 | E-01 (行156-161) | ○ |
| C-06 | InitializeToolsetを呼び出す | E-01 (行100) | ○ |
| C-07 | InitializeCustomToolsetでeng/restore-toolset.ps1を読み込む | E-01 (行87-97) | ○ |
| C-08 | MSBuild関数でビルドを実行 | E-01 (行119-139) | ○ |
| C-09 | try-catchでエラーを捕捉 | E-01 (行142, 172-176) | ○ |
| C-10 | Write-PipelineTelemetryErrorでエラー報告 | E-01 (行174) | ○ |
| C-11 | ExitWithExitCodeで終了 | E-01 (行175, 178) | ○ |
| C-12 | -nativeToolsOnMachineでNativeToolsOnMachine環境変数設定 | E-01 (行163-165) | ○ |
| C-13 | -restoreでInitializeNativeTools呼び出す | E-01 (行166-168) | ○ |
| C-14 | /p:Configurationでビルド構成を指定 | E-01 (行123) | ○ |
| C-15 | /p:DotNetBuildでproductBuildを指定 | E-01 (行132) | ○ |
| C-16 | -buildCheckで/checkオプションを追加 | E-01 (行105) | ○ |
| C-17 | -platformでプラットフォームを指定 | E-01 (行4, 104) | ○ |
| C-18 | バイナリログは$LogDir/Build.binlogに出力 | E-01 (行103) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードで確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Arcadeフレームワークの標準的なビルドスクリプト
- 0: 低リスク - PowerShellのパラメータバインディングによる型安全性
- 1: 中リスク - -cleanで$ArtifactsDir全体を削除するため注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] eng/restore-toolset.ps1が存在しない場合の動作確認
- [ ] Platform環境変数クリアの影響範囲確認
- [ ] CI環境でのバイナリログサイズの監視
- [ ] -msbuildEngineオプションの動作確認（dotnet vs vs）
