---
generated_at: 2026-01-30 13:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-install-cmake.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/native/install-cmake.sh` （ソースコード）
- E-02: `eng/common/native/common-library.sh` （依存スクリプト）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧）
- E-04: スクリプト内の引数解析部分（行16-62）
- E-05: スクリプト内の変数設定（行64-72）
- E-06: スクリプト内のクリーン処理（行75-93）
- E-07: スクリプト内のインストール処理（行96-116）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CMakeをダウンロード・インストールするスクリプト | E-01, E-03 | ○ |
| C-02 | common-library.shに依存 | E-01 (行6) | ○ |
| C-03 | tool_name=cmake | E-05 (行64) | ○ |
| C-04 | tool_arch=x86_64固定 | E-05 (行67) | ○ |
| C-05 | GetCurrentOSでOS取得 | E-05 (行65) | ○ |
| C-06 | 小文字に変換してフォルダ名に使用 | E-05 (行66) | ○ |
| C-07 | URL構成は{base_uri}/{tool_folder}/cmake/{archive} | E-05 (行72) | ○ |
| C-08 | clean=trueでディレクトリ削除 | E-06 (行76-79) | ○ |
| C-09 | シムファイルも削除 | E-06 (行81-84) | ○ |
| C-10 | 一時ファイルも削除 | E-06 (行86-90) | ○ |
| C-11 | 既存かつforce=falseでスキップ | E-07 (行96-99) | ○ |
| C-12 | DownloadAndExtractを呼び出し | E-07 (行101) | ○ |
| C-13 | ダウンロード失敗でexit 1 | E-07 (行103-106) | ○ |
| C-14 | NewScriptShimでシム生成 | E-07 (行110) | ○ |
| C-15 | シムはtrue引数で常に上書き | E-07 (行110) | ○ |
| C-16 | シム生成失敗でexit 1 | E-07 (行112-115) | ○ |
| C-17 | インストールパスは{install_path}/cmake/{version}/ | E-05 (行69) | ○ |
| C-18 | シムパスは{install_path}/cmake.sh | E-05 (行71) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 引数解析
- 0: 低リスク - クリーン処理
- 0: 低リスク - インストール処理

## 6) レビュアーチェックリスト（最小）
- [ ] 引数一覧がソースコードの解析ロジックと一致しているか確認
- [ ] URL構成が正しく記述されているか確認
- [ ] ファイル配置パスが正しく記述されているか確認
- [ ] エラーハンドリングが適切に説明されているか確認
