---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-install-dependencies.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/native/install-dependencies.sh` 行1-65
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行62

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -eでエラー時即座終了 | E-01 行3 | ○ |
| C-02 | 引数$1でOS種別を受け取る | E-01 行11 | ○ |
| C-03 | 引数なしの場合init-os-and-arch.shを呼び出し | E-01 行13-15 | ○ |
| C-04 | /etc/os-releaseを読み込んでディストリビューション判定 | E-01 行19-21 | ○ |
| C-05 | Debian系でaptを使用してパッケージインストール | E-01 行23-29 | ○ |
| C-06 | Fedora/RHEL/AzureLinux/CentOSでdnf/tdnfを使用 | E-01 行30-32 | ○ |
| C-07 | Amazon Linuxでdnfを使用 | E-01 行33-34 | ○ |
| C-08 | Alpineでapkを使用 | E-01 行35-36 | ○ |
| C-09 | 未サポートディストリビューションでexit 1 | E-01 行37-40 | ○ |
| C-10 | macOS系(osx/maccatalyst/ios等)でHomebrewを使用 | E-01 行43-57 | ○ |
| C-11 | HOMEBREW_NO_INSTALL_CLEANUPを設定 | E-01 行46 | ○ |
| C-12 | HOMEBREW_NO_INSTALLED_DEPENDENTS_CHECKを設定 | E-01 行47 | ○ |
| C-13 | brew bundleでパッケージインストール | E-01 行50-57 | ○ |
| C-14 | 未サポートプラットフォームでexit 1 | E-01 行60-63 | ○ |
| C-15 | localedefでen_US.UTF-8設定(Debian系) | E-01 行29 | ○ |
| C-16 | CMake、Clang、LLVM等の開発ツールをインストール | E-01 行26-27, 32, 34, 36, 51-56 | ○ |
| C-17 | バッチ一覧の説明と一致 | E-02 | ○ |
| C-18 | 目標処理時間5-15分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間「5-15分」は実測値またはベンチマーク結果が必要
  - 候補：CI/CDパイプラインログ / パフォーマンステスト結果 / 実行履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認
- [ ] 各ディストリビューションでの動作確認
- [ ] 必要パッケージリストの網羅性確認
