---
generated_at: 2026-01-30 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：62-install-tool.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間1-5分**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/native/install-tool.ps1` 行1-133
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行63

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToolName必須パラメータ | E-01 行34-35 | ○ |
| C-02 | InstallPath必須パラメータ | E-01 行36-37 | ○ |
| C-03 | BaseUri必須パラメータ | E-01 行38-39 | ○ |
| C-04 | Version必須パラメータ | E-01 行40-41 | ○ |
| C-05 | DownloadRetriesデフォルト5 | E-01 行45 | ○ |
| C-06 | RetryWaitTimeInSecondsデフォルト30 | E-01 行46 | ○ |
| C-07 | pipeline-logging-functions.ps1読み込み | E-01 行49 | ○ |
| C-08 | CommonLibrary.psm1読み込み | E-01 行52 | ○ |
| C-09 | Get-MachineArchitectureでアーキテクチャ検出 | E-01 行58 | ○ |
| C-10 | ToolOsはwin64/win32 | E-01 行59-62 | ○ |
| C-11 | ToolNameMoniker形式 | E-01 行63 | ○ |
| C-12 | Cleanモードで削除処理 | E-01 行68-83 | ○ |
| C-13 | 既存インストール時Forceなしでスキップ | E-01 行86-88 | ○ |
| C-14 | DownloadAndExtractでダウンロード・展開 | E-01 行90-95 | ○ |
| C-15 | インストール失敗時exit 1 | E-01 行97-100 | ○ |
| C-16 | Get-ChildItemで再帰検索 | E-01 行103 | ○ |
| C-17 | 複数ファイル発見時エラー | E-01 行104-106 | ○ |
| C-18 | ファイル未発見時エラー | E-01 行107-109 | ○ |
| C-19 | New-ScriptShimでシム生成 | E-01 行114-119 | ○ |
| C-20 | シム生成失敗時return 1 | E-01 行121-124 | ○ |
| C-21 | 例外時スタックトレース出力 | E-01 行128-131 | ○ |
| C-22 | 目標処理時間1-5分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間「1-5分」は実測値またはベンチマーク結果が必要
  - 候補：CI/CDパイプラインログ / 実行履歴 / ネットワーク帯域依存の試算

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認
- [ ] CommonLibrary.psm1の依存関数の存在確認
- [ ] Azure Blob StorageのURI形式の確認
