---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-symbols-validation.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/post-build/symbols-validation.ps1` 行1-338
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行68

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InputPath必須パラメータ | E-01 行2 | ○ |
| C-02 | ExtractPath必須パラメータ | E-01 行3 | ○ |
| C-03 | DotnetSymbolVersion必須パラメータ | E-01 行4 | ○ |
| C-04 | MaxParallelJobs=16 | E-01 行13 | ○ |
| C-05 | MaxRetry=5 | E-01 行16 | ○ |
| C-06 | SecondsBetweenLoadChecks=10 | E-01 行19 | ○ |
| C-07 | ERROR_BADEXTRACT=-1 | E-01 行22 | ○ |
| C-08 | ERROR_FILEDOESNOTEXIST=-2 | E-01 行23 | ○ |
| C-09 | InputPath未存在時に正常終了 | E-01 行32-35 | ○ |
| C-10 | HashSetで除外リスト管理 | E-01 行30 | ○ |
| C-11 | SymbolExclusionFile読み込み | E-01 行38-44 | ○ |
| C-12 | 検証対象拡張子.dll/.exe/.so/.dylib | E-01 行66 | ○ |
| C-13 | ZipFile.ExtractToDirectory使用 | E-01 行77 | ○ |
| C-14 | 参照アセンブリ(\ref\)スキップ | E-01 行92-95 | ○ |
| C-15 | dotnet-symbolでMSDL問い合わせ | E-01 行135, 170-174 | ○ |
| C-16 | dotnet-symbolでSymWeb問い合わせ | E-01 行135, 175-179 | ○ |
| C-17 | シンボル種別（PDB、NGen PDB、SO DBG、Dylib DWARF） | E-01 行112-125 | ○ |
| C-18 | -Clean時に展開ディレクトリ削除 | E-01 行204-206 | ○ |
| C-19 | Microsoft.DotNet.Darc.*スキップ | E-01 行255-258 | ○ |
| C-20 | Microsoft.DotNet.Maestro.Tasks.*スキップ | E-01 行260-263 | ○ |
| C-21 | Start-Jobで並列実行 | E-01 行268 | ○ |
| C-22 | ジョブ数監視ループ | E-01 行272-276 | ○ |
| C-23 | CheckJobResult関数 | E-01 行216-236 | ○ |
| C-24 | InstallDotnetSymbol関数 | E-01 行307-322 | ○ |
| C-25 | dotnet tool install --global | E-01 行320 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は完全

## 6) レビュアーチェックリスト（最小）
- [ ] シンボルサーバーへのネットワークアクセス確認
- [ ] dotnet-symbolバージョンの最新確認
- [ ] 除外リストの妥当性確認
- [ ] 並列ジョブ数の適切性確認
