---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-sourcelink-validation.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/post-build/sourcelink-validation.ps1` 行1-328
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行71

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InputPath必須パラメータ | E-01 行2 | ○ |
| C-02 | ExtractPath必須パラメータ | E-01 行3 | ○ |
| C-03 | GHRepoNameオプションパラメータ | E-01 行4 | ○ |
| C-04 | GHCommitオプションパラメータ | E-01 行5 | ○ |
| C-05 | SourcelinkCliVersion必須パラメータ | E-01 行6 | ○ |
| C-06 | $ciと$disableConfigureToolsetImport設定 | E-01 行15-16 | ○ |
| C-07 | RepoFilesハッシュテーブル | E-01 行22 | ○ |
| C-08 | MaxParallelJobs=16 | E-01 行25 | ○ |
| C-09 | MaxRetries=5 | E-01 行27 | ○ |
| C-10 | RetryWaitTimeInSeconds=30 | E-01 行28 | ○ |
| C-11 | SecondsBetweenLoadChecks=10 | E-01 行31 | ○ |
| C-12 | InputPath未存在時に正常終了 | E-01 行33-36 | ○ |
| C-13 | 検証対象拡張子.dll/.exe/.pdb | E-01 行56 | ○ |
| C-14 | .resources.dllスキップ | E-01 行80-85 | ○ |
| C-15 | sourcelink print-urls実行 | E-01 行98 | ○ |
| C-16 | HTTPリンクのパターンマッチ | E-01 行104 | ○ |
| C-17 | submodulesリンクスキップ | E-01 行123-126 | ○ |
| C-18 | GitHub/githubusercontentのみ検証 | E-01 行127 | ○ |
| C-19 | Invoke-WebRequest -Method HEAD | E-01 行129 | ○ |
| C-20 | タイムアウト5秒 | E-01 行129 | ○ |
| C-21 | リトライ処理 | E-01 行146-150 | ○ |
| C-22 | GHRepoName形式検証(org/repo) | E-01 行220-228 | ○ |
| C-23 | GHRepoName org-repo形式の変換 | E-01 行226 | ○ |
| C-24 | GHCommit40文字16進数検証 | E-01 行230-233 | ○ |
| C-25 | GitHub APIでファイルリスト取得 | E-01 行236-254 | ○ |
| C-26 | *.symbols.nupkg処理 | E-01 行266 | ○ |
| C-27 | Start-Job並列実行 | E-01 行269 | ○ |
| C-28 | InstallSourcelinkCli関数 | E-01 行296-311 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は完全

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub APIへのアクセス確認（レート制限に注意）
- [ ] sourcelink CLIバージョンの最新確認
- [ ] SourceLink設定の正確性確認
- [ ] 並列ジョブ数の適切性確認
- [ ] submoduleリンクの処理方針確認
