---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：71-check-channel-consistency.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数（1-10チャンネル）**：根拠不足
  2. **N/A**：根拠不足
  3. **N/A**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/post-build/check-channel-consistency.ps1` 行1-4（パラメータ定義）
- E-02: `eng/common/post-build/check-channel-consistency.ps1` 行17-20（空チェック処理）
- E-03: `eng/common/post-build/check-channel-consistency.ps1` 行24（チャンネルID抽出ロジック）
- E-04: `eng/common/post-build/check-channel-consistency.ps1` 行28-33（整合性チェックループ）
- E-05: `eng/common/post-build/check-channel-consistency.ps1` 行38-40（エラー時終了処理）
- E-06: `eng/common/post-build/check-channel-consistency.ps1` 行15（tools.ps1読み込み）
- E-07: `eng/common/post-build/check-channel-consistency.ps1` 行44-48（例外ハンドリング）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行72（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PromoteToChannelsは必須パラメータ | E-01 | ○ |
| C-02 | AvailableChannelIdsは必須パラメータ | E-01 | ○ |
| C-03 | PromoteToChannelsが空の場合は警告出力してスキップ | E-02 | ○ |
| C-04 | チャンネルIDは非数字で分割して抽出 | E-03 | ○ |
| C-05 | 各チャンネルIDをAvailableChannelIdsと比較 | E-04 | ○ |
| C-06 | 不整合時はエラーメッセージ出力 | E-04 | ○ |
| C-07 | エラー発生時は終了コード1で終了 | E-05 | ○ |
| C-08 | tools.ps1を読み込んで共通関数を使用 | E-06 | ○ |
| C-09 | 例外発生時はテレメトリエラーを出力 | E-07 | ○ |
| C-10 | CheckChannelConsistencyカテゴリでテレメトリ出力 | E-07 | ○ |
| C-11 | 正常終了時は"done."を出力 | E-04 (行42) | ○ |
| C-12 | リリースチャンネル設定の検証がバッチの目的 | E-08 | ○ |
| C-13 | データベース操作なし | E-01〜E-07（全体構造） | ○ |
| C-14 | ファイル出力なし | E-01〜E-07（全体構造） | ○ |
| C-15 | 想定処理件数は1-10チャンネル | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠がソースコードから特定できない
  - 候補：Maestro設定ドキュメント / 実運用データ / Azure DevOpsパイプライン設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- 1: 中リスク - 想定処理件数は推定値のため、実際の運用と異なる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ定義がソースコードと一致しているか確認
- [ ] エラー処理フローが正しく記載されているか確認
- [ ] 想定処理件数が実運用と合致するか確認
