---
generated_at: 2026-01-30 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：72-publish-using-darc.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（数分〜数十分）**：根拠不足
  2. **N/A**：根拠不足
  3. **N/A**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/post-build/publish-using-darc.ps1` 行1-13（パラメータ定義）
- E-02: `eng/common/post-build/publish-using-darc.ps1` 行21（tools.ps1読み込み）
- E-03: `eng/common/post-build/publish-using-darc.ps1` 行23（Get-Darc呼び出し）
- E-04: `eng/common/post-build/publish-using-darc.ps1` 行25-47（オプションパラメータ構築）
- E-05: `eng/common/post-build/publish-using-darc.ps1` 行49-58（darcコマンド実行）
- E-06: `eng/common/post-build/publish-using-darc.ps1` 行60-63（終了コードチェック）
- E-07: `eng/common/post-build/publish-using-darc.ps1` 行67-71（例外ハンドリング）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行73（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildIdは必須パラメータでint型 | E-01 | ○ |
| C-02 | PublishingInfraVersionは必須パラメータでint型 | E-01 | ○ |
| C-03 | AzdoTokenは必須パラメータ | E-01 | ○ |
| C-04 | MaestroApiEndPointのデフォルトはhttps://maestro.dot.net | E-01 | ○ |
| C-05 | WaitPublishingFinishは必須パラメータ | E-01 | ○ |
| C-06 | Get-Darc関数でDARCパスを取得 | E-03 | ○ |
| C-07 | ArtifactsPublishingAdditionalParametersが設定されている場合は--artifact-publishing-parameters追加 | E-04 | ○ |
| C-08 | SymbolPublishingAdditionalParametersが設定されている場合は--symbol-publishing-parameters追加 | E-04 | ○ |
| C-09 | WaitPublishingFinish=falseの場合は--no-wait追加 | E-04 | ○ |
| C-10 | RequireDefaultChannels=trueの場合は--default-channels-required追加 | E-04 | ○ |
| C-11 | SkipAssetsPublishing=trueの場合は--skip-assets-publishing追加 | E-04 | ○ |
| C-12 | darc add-build-to-channelコマンドを実行 | E-05 | ○ |
| C-13 | --source-branch mainが固定値で設定される | E-05 | ○ |
| C-14 | --ciと--verboseフラグが設定される | E-05 | ○ |
| C-15 | 終了コードが0以外の場合はエラー終了 | E-06 | ○ |
| C-16 | 例外発生時はPromoteBuildカテゴリでテレメトリ出力 | E-07 | ○ |
| C-17 | Maestro経由でパッケージを公開 | E-08 | ○ |
| C-18 | 目標処理時間は数分〜数十分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠がソースコードから特定できない
  - 候補：実運用データ / Azure DevOpsパイプライン実行履歴 / Maestroドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義とコマンド構築ロジックはソースコードと完全一致
- 1: 中リスク - 処理時間は実運用環境に依存するため、推定値

## 6) レビュアーチェックリスト（最小）
- [ ] すべてのパラメータ定義がソースコードと一致しているか確認
- [ ] オプションパラメータの条件分岐が正しく記載されているか確認
- [ ] DARCコマンドのオプションがソースコードと一致しているか確認
- [ ] 実際のパイプライン実行時間と目標処理時間が合致するか確認
