---
generated_at: 2026-01-30 13:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-sdl.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/sdl.ps1` 行2-9（関数定義とパラメータ）
- E-02: `eng/common/sdl/sdl.ps1` 行11-14（初期化設定）
- E-03: `eng/common/sdl/sdl.ps1` 行20（tools.ps1読み込み）
- E-04: `eng/common/sdl/sdl.ps1` 行22（NuGet引数構築）
- E-05: `eng/common/sdl/sdl.ps1` 行24-26（バージョン指定処理）
- E-06: `eng/common/sdl/sdl.ps1` 行28（Start-Process実行）
- E-07: `eng/common/sdl/sdl.ps1` 行30（guardian.cmd検索）
- E-08: `eng/common/sdl/sdl.ps1` 行32-35（エラー処理）
- E-09: `eng/common/sdl/sdl.ps1` 行37（パス返却）
- E-10: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行75（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pathは必須パラメータ | E-01 | ○ |
| C-02 | Versionはオプションパラメータ | E-01 | ○ |
| C-03 | ErrorActionPreferenceを'Stop'に設定 | E-02 | ○ |
| C-04 | StrictModeをVersion 2.0に設定 | E-02 | ○ |
| C-05 | tools.ps1を読み込み | E-03 | ○ |
| C-06 | Microsoft.Guardian.Cliパッケージをインストール | E-04 | ○ |
| C-07 | SecurityToolsフィードからパッケージを取得 | E-04 | ○ |
| C-08 | Version指定時は引数に追加 | E-05 | ○ |
| C-09 | Start-Processでnugetを実行 | E-06 | ○ |
| C-10 | -NoNewWindow -Waitオプションで実行 | E-06 | ○ |
| C-11 | Get-ChildItemで guardian.cmdを再帰検索 | E-07 | ○ |
| C-12 | guardian.cmd未検出時はテレメトリエラー | E-08 | ○ |
| C-13 | guardian.cmdのフルパスを返却 | E-09 | ○ |
| C-14 | セキュリティスキャンを実行するのがバッチの目的 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対してソースコードから根拠が確認できる

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトが比較的小規模で、すべてのロジックが確認可能
- 0: 低リスク - 関数の入出力が明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ定義がソースコードと一致しているか確認
- [ ] NuGetフィードURLが正しいか確認
- [ ] エラー処理が正しく記載されているか確認
