---
generated_at: 2026-01-30 13:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：75-init-sdl.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（数秒〜数十秒）**：根拠不足
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/init-sdl.ps1` 行1-8（パラメータ定義）
- E-02: `eng/common/sdl/init-sdl.ps1` 行10-13（初期化設定）
- E-03: `eng/common/sdl/init-sdl.ps1` 行19（tools.ps1読み込み）
- E-04: `eng/common/sdl/init-sdl.ps1` 行22（ProgressPreference設定）
- E-05: `eng/common/sdl/init-sdl.ps1` 行25（Base64エンコード）
- E-06: `eng/common/sdl/init-sdl.ps1` 行26-27（URI構築）
- E-07: `eng/common/sdl/init-sdl.ps1` 行31（.gdnフォルダパス設定）
- E-08: `eng/common/sdl/init-sdl.ps1` 行35-37（Guardian init実行）
- E-09: `eng/common/sdl/init-sdl.ps1` 行38-41（init失敗時のエラー処理）
- E-10: `eng/common/sdl/init-sdl.ps1` 行43-44（Guardian baseline実行）
- E-11: `eng/common/sdl/init-sdl.ps1` 行45-48（baseline失敗時のエラー処理）
- E-12: `eng/common/sdl/init-sdl.ps1` 行51-54（例外ハンドリング）
- E-13: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行76（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BranchNameのデフォルトは'master' | E-01 | ○ |
| C-02 | GuardianLoggerLevelのデフォルトは'Standard' | E-01 | ○ |
| C-03 | ErrorActionPreferenceを'Stop'に設定 | E-02 | ○ |
| C-04 | tools.ps1を読み込み | E-03 | ○ |
| C-05 | ProgressPreferenceを'SilentlyContinue'に設定 | E-04 | ○ |
| C-06 | Azure DevOpsトークンをBase64エンコード | E-05 | ○ |
| C-07 | sdl-tool-cfgリポジトリへのURI構築 | E-06 | ○ |
| C-08 | .gdnフォルダパスを設定 | E-07 | ○ |
| C-09 | Guardian initコマンドを実行 | E-08 | ○ |
| C-10 | init失敗時はテレメトリエラーとExitWithExitCode | E-09 | ○ |
| C-11 | Guardian baselineコマンドで'mainbaseline'を作成 | E-10 | ○ |
| C-12 | baseline失敗時はテレメトリエラーとExitWithExitCode | E-11 | ○ |
| C-13 | 例外発生時はSdlカテゴリでテレメトリ出力 | E-12 | ○ |
| C-14 | セキュリティツールの設定と初期化がバッチの目的 | E-13 | ○ |
| C-15 | 正常終了時はExitWithExitCode 0 | E-08 (行49) | ○ |
| C-16 | 目標処理時間は数秒〜数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠がソースコードから特定できない
  - 候補：実運用データ / Azure DevOpsパイプライン実行履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- 1: 中リスク - 認証情報の取り扱いに注意（Base64エンコード）

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ定義がソースコードと一致しているか確認
- [ ] Guardianコマンドのオプションが正しく記載されているか確認
- [ ] エラー処理フローが正しく記載されているか確認
- [ ] 認証情報の取り扱いが適切か確認
