---
generated_at: 2026-01-30 13:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：76-run-sdl.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（数分〜数十分）**：根拠不足
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/run-sdl.ps1` 行1-7（パラメータ定義）
- E-02: `eng/common/sdl/run-sdl.ps1` 行9-12（初期化設定）
- E-03: `eng/common/sdl/run-sdl.ps1` 行18-19（tools.ps1読み込み）
- E-04: `eng/common/sdl/run-sdl.ps1` 行22（gdnConfigPath設定）
- E-05: `eng/common/sdl/run-sdl.ps1` 行23-29（CLIパス検証）
- E-06: `eng/common/sdl/run-sdl.ps1` 行31-33（設定ファイル検索と出力）
- E-07: `eng/common/sdl/run-sdl.ps1` 行35-42（Guardian run実行）
- E-08: `eng/common/sdl/run-sdl.ps1` 行44-48（例外ハンドリング）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行77（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GuardianLoggerLevelのデフォルトは'Standard' | E-01 | ○ |
| C-02 | tools.ps1を読み込み | E-03 | ○ |
| C-03 | .gdn/rディレクトリパスを設定 | E-04 | ○ |
| C-04 | GuardianCliLocationの存在をTest-Pathで確認 | E-05 | ○ |
| C-05 | CLIパス無効時はテレメトリエラー出力して終了コード1 | E-05 | ○ |
| C-06 | Get-ChildItemで*.gdnconfigを再帰検索 | E-06 | ○ |
| C-07 | 設定ファイル一覧をログ出力 | E-06 | ○ |
| C-08 | Guardian runコマンドを実行 | E-07 | ○ |
| C-09 | --baseline mainbaselineオプションを使用 | E-07 | ○ |
| C-10 | --update-baseline $UpdateBaselineオプションを使用 | E-07 | ○ |
| C-11 | --config @gdnConfigFilesで複数設定ファイルを指定 | E-07 | ○ |
| C-12 | Exit-IfNZECでエラーチェック | E-07 | ○ |
| C-13 | 例外発生時はSdlカテゴリでテレメトリ出力 | E-08 | ○ |
| C-14 | セキュリティスキャンツールを実行するのがバッチの目的 | E-09 | ○ |
| C-15 | 目標処理時間は数分〜数十分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠がソースコードから特定できない
  - 候補：実運用データ / Azure DevOpsパイプライン実行履歴 / ツール別ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- 0: 低リスク - パラメータとコマンドオプションの対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ定義がソースコードと一致しているか確認
- [ ] Guardian runコマンドのオプションが正しく記載されているか確認
- [ ] エラー処理フローが正しく記載されているか確認
- [ ] 実際のスキャン時間と目標処理時間が合致するか確認
