---
generated_at: 2026-01-30 13:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：77-execute-all-sdl-tools.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（数十分〜数時間）**：根拠不足
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/execute-all-sdl-tools.ps1` 行1-40（パラメータ定義）
- E-02: `eng/common/sdl/execute-all-sdl-tools.ps1` 行42-52（初期化設定）
- E-03: `eng/common/sdl/execute-all-sdl-tools.ps1` 行54-60（リポジトリ名正規化）
- E-04: `eng/common/sdl/execute-all-sdl-tools.ps1` 行62-66（Guardian CLIパス解決）
- E-05: `eng/common/sdl/execute-all-sdl-tools.ps1` 行68-75（CLIパス検証）
- E-06: `eng/common/sdl/execute-all-sdl-tools.ps1` 行77-79（init-sdl.ps1呼び出し）
- E-07: `eng/common/sdl/execute-all-sdl-tools.ps1` 行82-95（TSAオンボード）
- E-08: `eng/common/sdl/execute-all-sdl-tools.ps1` 行97-118（Configure-ToolsList関数定義）
- E-09: `eng/common/sdl/execute-all-sdl-tools.ps1` 行120-124（ツールリスト設定呼び出し）
- E-10: `eng/common/sdl/execute-all-sdl-tools.ps1` 行126-134（run-sdl.ps1呼び出し）
- E-11: `eng/common/sdl/execute-all-sdl-tools.ps1` 行136-152（TSA公開）
- E-12: `eng/common/sdl/execute-all-sdl-tools.ps1` 行154-161（BreakOnFailure処理）
- E-13: `eng/common/sdl/execute-all-sdl-tools.ps1` 行163-167（例外ハンドリング）
- E-14: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行78（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Repositoryのデフォルトは$env:BUILD_REPOSITORY_NAME | E-01 | ○ |
| C-02 | BranchNameのデフォルトは$env:BUILD_SOURCEBRANCH | E-01 | ○ |
| C-03 | SourceDirectoryのデフォルトは$env:BUILD_SOURCESDIRECTORY | E-01 | ○ |
| C-04 | ArtifactsDirectoryのデフォルトは'artifacts' | E-01 | ○ |
| C-05 | TsaPublishのデフォルトは$False | E-01 | ○ |
| C-06 | BreakOnFailureのデフォルトは$False | E-01 | ○ |
| C-07 | GuardianLoggerLevelのデフォルトは'Standard' | E-01 | ○ |
| C-08 | tools.ps1を読み込み | E-02 | ○ |
| C-09 | リポジトリ名を"org/repo"形式に正規化 | E-03 | ○ |
| C-10 | GuardianPackageNameからCLIパスを構築 | E-04 | ○ |
| C-11 | CLIパス無効時はエラー終了 | E-05 | ○ |
| C-12 | init-sdl.ps1を呼び出し | E-06 | ○ |
| C-13 | TsaOnboard=trueの場合にguardian tsa-onboardを実行 | E-07 | ○ |
| C-14 | TSAオンボードに必要なパラメータを検証 | E-07 | ○ |
| C-15 | Configure-ToolsList関数を内部で定義 | E-08 | ○ |
| C-16 | configure-sdl-tool.ps1を呼び出し | E-08 | ○ |
| C-17 | ArtifactToolsListをArtifactsDirectoryで設定 | E-09 | ○ |
| C-18 | SourceToolsListをSourceDirectoryで設定 | E-09 | ○ |
| C-19 | CustomToolsListをnullターゲットで設定 | E-09 | ○ |
| C-20 | run-sdl.ps1を呼び出し | E-10 | ○ |
| C-21 | TsaPublish=trueの場合にguardian tsa-publishを実行 | E-11 | ○ |
| C-22 | BreakOnFailure=trueの場合にguardian breakを実行 | E-12 | ○ |
| C-23 | BreakOnFailure=falseの場合はビルドを通過させる | E-12 | ○ |
| C-24 | 例外発生時はSdlカテゴリでテレメトリ出力 | E-13 | ○ |
| C-25 | 目標処理時間は数十分〜数時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠がソースコードから特定できない
  - 候補：実運用データ / Azure DevOpsパイプライン実行履歴 / ツール別ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は非常に高い
- 0: 低リスク - パラメータとフロー制御の対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] すべてのパラメータ定義がソースコードと一致しているか確認
- [ ] 処理フローの順序が正しく記載されているか確認
- [ ] TSA関連の条件分岐が正しく記載されているか確認
- [ ] BreakOnFailureの動作が正しく記載されているか確認
- [ ] 実際のスキャン時間と目標処理時間が合致するか確認
