---
generated_at: 2026-01-30 13:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：78-configure-sdl-tool.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（数秒〜数十秒）**：根拠不足
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/configure-sdl-tool.ps1` 行1-23（パラメータ定義）
- E-02: `eng/common/sdl/configure-sdl-tool.ps1` 行25-28（初期化設定）
- E-03: `eng/common/sdl/configure-sdl-tool.ps1` 行33-35（tools.ps1読み込み）
- E-04: `eng/common/sdl/configure-sdl-tool.ps1` 行38-47（ツールリスト正規化）
- E-05: `eng/common/sdl/configure-sdl-tool.ps1` 行49-50（ツールリスト出力）
- E-06: `eng/common/sdl/configure-sdl-tool.ps1` 行53-60（CLIパス検証）
- E-07: `eng/common/sdl/configure-sdl-tool.ps1` 行62-68（ツールループと設定名構築）
- E-08: `eng/common/sdl/configure-sdl-tool.ps1` 行71（出力パス決定）
- E-09: `eng/common/sdl/configure-sdl-tool.ps1` 行74-81（CredScanパラメータ）
- E-10: `eng/common/sdl/configure-sdl-tool.ps1` 行82-86（PoliCheckパラメータ）
- E-11: `eng/common/sdl/configure-sdl-tool.ps1` 行88-92（CodeQL/Semmleパラメータ）
- E-12: `eng/common/sdl/configure-sdl-tool.ps1` 行94-100（BinSkimパラメータ）
- E-13: `eng/common/sdl/configure-sdl-tool.ps1` 行111-121（Guardian configure実行）
- E-14: `eng/common/sdl/configure-sdl-tool.ps1` 行123（設定ファイル作成確認）
- E-15: `eng/common/sdl/configure-sdl-tool.ps1` 行126-129（例外ハンドリング）
- E-16: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行79（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GuardianLoggerLevelのデフォルトは'Standard' | E-01 | ○ |
| C-02 | ToolsListの各要素は文字列またはハッシュテーブル | E-01 | ○ |
| C-03 | tools.ps1を読み込み | E-03 | ○ |
| C-04 | 文字列はハッシュテーブルに変換される | E-04 | ○ |
| C-05 | ScenarioとArgsのデフォルト値を設定 | E-04 | ○ |
| C-06 | ツールリストをログ出力 | E-05 | ○ |
| C-07 | CLIパス無効時はエラー終了 | E-06 | ○ |
| C-08 | ToolNameとScenarioから設定名を構築 | E-07 | ○ |
| C-09 | 出力ファイル名は{name}-configure.gdnconfig | E-08 | ○ |
| C-10 | CredScanにTargetDirectory、OutputType: preを追加 | E-09 | ○ |
| C-11 | PoliCheckにTargetを追加 | E-10 | ○ |
| C-12 | semmleとcodeqlは同等に処理 | E-11 | ○ |
| C-13 | CodeQLにSourceCodeDirectoryを追加 | E-11 | ○ |
| C-14 | BinSkimに_.pdb除外パターンを追加 | E-12 | ○ |
| C-15 | Guardian configureコマンドを実行 | E-13 | ○ |
| C-16 | --forceオプションで上書き | E-13 | ○ |
| C-17 | --noninteractiveオプションで非対話実行 | E-13 | ○ |
| C-18 | Exit-IfNZECでエラーチェック | E-13 | ○ |
| C-19 | 設定ファイル作成をログ出力 | E-14 | ○ |
| C-20 | 例外発生時はSdlカテゴリでテレメトリ出力 | E-15 | ○ |
| C-21 | セキュリティツールのパラメータ設定がバッチの目的 | E-16 | ○ |
| C-22 | 目標処理時間は数秒〜数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠がソースコードから特定できない
  - 候補：実運用データ / Azure DevOpsパイプライン実行履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は非常に高い
- 0: 低リスク - ツール別パラメータ設定が明確にコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ定義がソースコードと一致しているか確認
- [ ] ツール別デフォルトパラメータが正しく記載されているか確認
- [ ] Guardian configureコマンドのオプションが正しいか確認
- [ ] BinSkimの_.pdb除外パターンが正しいか確認
