---
generated_at: 2026-01-30 13:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：79-extract-artifact-packages.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数（数個〜数百個）**：根拠不足
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/extract-artifact-packages.ps1` 行1-4（パラメータ定義）
- E-02: `eng/common/sdl/extract-artifact-packages.ps1` 行6-8（初期化設定）
- E-03: `eng/common/sdl/extract-artifact-packages.ps1` 行11-25（ExtractArtifacts関数）
- E-04: `eng/common/sdl/extract-artifact-packages.ps1` 行31-32（tools.ps1読み込み）
- E-05: `eng/common/sdl/extract-artifact-packages.ps1` 行34-75（ExtractPackageスクリプトブロック）
- E-06: `eng/common/sdl/extract-artifact-packages.ps1` 行44（RelevantExtensions定義）
- E-07: `eng/common/sdl/extract-artifact-packages.ps1` 行47-48（パッケージID取得、ExtractPath構築）
- E-08: `eng/common/sdl/extract-artifact-packages.ps1` 行55-65（ZIP展開とファイル抽出）
- E-09: `eng/common/sdl/extract-artifact-packages.ps1` 行76（Measure-Command）
- E-10: `eng/common/sdl/extract-artifact-packages.ps1` 行78-82（例外ハンドリング）
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行80（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InputPathは必須パラメータ | E-01 | ○ |
| C-02 | ExtractPathは必須パラメータ | E-01 | ○ |
| C-03 | ErrorActionPreferenceを'Stop'に設定 | E-02 | ○ |
| C-04 | InputPath不存在時は正常終了 | E-03 | ○ |
| C-05 | Get-ChildItemで*.nupkgを検索 | E-03 | ○ |
| C-06 | Start-Jobで並列展開 | E-03 | ○ |
| C-07 | Wait-Jobで完了待機 | E-03 | ○ |
| C-08 | tools.ps1を読み込み | E-04 | ○ |
| C-09 | 抽出対象は.dll、.exe、.pdbのみ | E-06 | ○ |
| C-10 | パッケージIDはファイル名から拡張子を除いて取得 | E-07 | ○ |
| C-11 | $using:ExtractPathでジョブ内から参照 | E-07 | ○ |
| C-12 | ZipFile.OpenReadで読み取り | E-08 | ○ |
| C-13 | ZipFileExtensions.ExtractToFileで展開 | E-08 | ○ |
| C-14 | パッケージ内のディレクトリ構造を保持 | E-08 | ○ |
| C-15 | Measure-Commandで処理時間計測 | E-09 | ○ |
| C-16 | 例外発生時はSdlカテゴリでテレメトリ出力 | E-10 | ○ |
| C-17 | NuGetパッケージをスキャン用に展開するのがバッチの目的 | E-11 | ○ |
| C-18 | 想定処理件数は数個〜数百個 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠がソースコードから特定できない
  - 候補：実運用データ / .NET runtimeビルド出力 / パイプライン実行履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- 0: 低リスク - 処理ロジックが明確にコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ定義がソースコードと一致しているか確認
- [ ] 抽出対象拡張子が正しく記載されているか確認
- [ ] 並列処理のロジックが正しく記載されているか確認
- [ ] 実際のビルドで処理されるパッケージ数を確認
