---
generated_at: 2026-01-30 10:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-eng/common/cibuild.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/eng/common/cibuild.sh` (ソースコード、17行)
- E-02: `/Users/tomoka.baba/Work/runtime-main/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)
- E-03: `/Users/tomoka.baba/Work/runtime-main/eng/common/build.sh` (委譲先スクリプト)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BASH_SOURCE[0]からパスを取得 | E-01 (行3) | ○ |
| C-02 | シンボリックリンクを解決 | E-01 (行6-13) | ○ |
| C-03 | scriptrootを設定 | E-01 (行14) | ○ |
| C-04 | build.shを呼び出す | E-01 (行16) | ○ |
| C-05 | --restoreフラグを指定 | E-01 (行16) | ○ |
| C-06 | --buildフラグを指定 | E-01 (行16) | ○ |
| C-07 | --testフラグを指定 | E-01 (行16) | ○ |
| C-08 | --pack, --publishフラグを指定 | E-01 (行16) | ○ |
| C-09 | --ciフラグを指定 | E-01 (行16) | ○ |
| C-10 | $@で追加引数を受け渡し | E-01 (行16) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードで確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなラッパースクリプト
- 0: 低リスク - すべての処理は検証済みのbuild.shに委譲
- 1: 中リスク - CIBuild.cmdとの違い（-signオプションなし）に注意

## 6) レビュアーチェックリスト（最小）
- [ ] CIBuild.cmdとの機能パリティ確認（-signオプションの扱い）
- [ ] ソースコマンド（.）での呼び出しによる環境変数への影響確認
- [ ] 追加引数のエスケープ処理の確認
