---
generated_at: 2026-01-30 13:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：80-extract-artifact-archives.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数（数個〜数十個）**：根拠不足
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/extract-artifact-archives.ps1` 行1-9（パラメータ定義とコメント）
- E-02: `eng/common/sdl/extract-artifact-archives.ps1` 行11-14（初期化設定）
- E-03: `eng/common/sdl/extract-artifact-archives.ps1` 行19-21（tools.ps1読み込み）
- E-04: `eng/common/sdl/extract-artifact-archives.ps1` 行27-30（アーカイブ検索）
- E-05: `eng/common/sdl/extract-artifact-archives.ps1` 行32-54（並列展開ジョブ）
- E-06: `eng/common/sdl/extract-artifact-archives.ps1` 行35-36（展開先ディレクトリ構築）
- E-07: `eng/common/sdl/extract-artifact-archives.ps1` 行38（ディレクトリ作成）
- E-08: `eng/common/sdl/extract-artifact-archives.ps1` 行45（tar -xf実行）
- E-09: `eng/common/sdl/extract-artifact-archives.ps1` 行47-49（終了コードチェック）
- E-10: `eng/common/sdl/extract-artifact-archives.ps1` 行56（Receive-Job -Wait）
- E-11: `eng/common/sdl/extract-artifact-archives.ps1` 行59-62（例外ハンドリング）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行81（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InputPathは必須パラメータ | E-01 | ○ |
| C-02 | ExtractPathは必須パラメータ | E-01 | ○ |
| C-03 | InputPathとExtractPathは同じでも可 | E-01 | ○ |
| C-04 | ErrorActionPreferenceを'Stop'に設定 | E-02 | ○ |
| C-05 | tools.ps1を読み込み | E-03 | ○ |
| C-06 | Get-ChildItemで*.tar.gzと*.zipを検索 | E-04 | ○ |
| C-07 | Start-Jobで並列展開 | E-05 | ○ |
| C-08 | 展開先は{filename}.extracted | E-06 | ○ |
| C-09 | New-Itemでディレクトリ作成 | E-07 | ○ |
| C-10 | tar -xf -C で展開 | E-08 | ○ |
| C-11 | 2>&1でstderrをstdoutにリダイレクト | E-08 | ○ |
| C-12 | 非ゼロ終了コードで例外スロー | E-09 | ○ |
| C-13 | Receive-Job -Waitで結果取得 | E-10 | ○ |
| C-14 | Measure-Commandで処理時間計測 | E-05 (行23) | ○ |
| C-15 | 例外発生時はSdlカテゴリでテレメトリ出力 | E-11 | ○ |
| C-16 | アーカイブファイルをスキャン用に展開するのがバッチの目的 | E-12 | ○ |
| C-17 | 想定処理件数は数個〜数十個 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠がソースコードから特定できない
  - 候補：実運用データ / .NET runtimeビルド出力 / パイプライン実行履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- 0: 低リスク - 処理ロジックが明確にコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ定義がソースコードと一致しているか確認
- [ ] tarコマンドのオプションが正しく記載されているか確認
- [ ] 並列処理のロジックが正しく記載されているか確認
- [ ] 実際のビルドで処理されるアーカイブ数を確認
