---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：81-trim-assets-version

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間「数分以内」**：具体的な根拠なし
  2. **セキュリティスキャン精度向上の効果**：間接的な推測
  3. **前後処理との関連**：バッチ一覧からの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/trim-assets-version.ps1` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内 `.SYNOPSIS` セクション - 機能説明
- E-04: ソースコード内 `Param()` ブロック - パラメータ定義
- E-05: ソースコード内 `Install-VersionTools-Cli` 関数 - ツールインストール処理
- E-06: ソースコード内 `$CliToolName` 変数 - ツール名定義
- E-07: ソースコード内 `$feed` 変数 - NuGetフィードURL

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スクリプトはNuGetアセットファイル名からバージョン情報をトリムする | E-01, E-03 | ○ |
| C-02 | InputPathパラメータは必須でディレクトリパスを受け取る | E-04 | ○ |
| C-03 | Recursiveパラメータのデフォルト値は$true | E-04 | ○ |
| C-04 | Microsoft.DotNet.VersionTools.Cliツールをインストールする | E-05, E-06 | ○ |
| C-05 | dotnet-engフィードからツールを取得する | E-07 | ○ |
| C-06 | 入力パスが存在しない場合ExitCode 1で終了 | E-01 (34-37行目) | ○ |
| C-07 | tools.ps1を読み込んで環境を初期化する | E-01 (49行目) | ○ |
| C-08 | InitializeDotNetCliでSDK環境をセットアップ | E-01 (52行目) | ○ |
| C-09 | Read-ArcadeSdkVersionでツールバージョンを決定 | E-01 (55行目) | ○ |
| C-10 | ツールインストール確認失敗時はエラー終了 | E-01 (59-62行目) | ○ |
| C-11 | trim-assets-versionコマンドを実行 | E-01 (65-68行目) | ○ |
| C-12 | $ci変数をtrueに設定してCI環境動作を前提 | E-01 (48行目) | ○ |
| C-13 | テレメトリカテゴリは'Sdl' | E-01 (60, 73行目) | ○ |
| C-14 | SDLセキュリティ検証プロセスの一部として使用 | E-02 | ○ |
| C-15 | 目標処理時間は数分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間「数分以内」の具体的な根拠がない
  - 候補：パフォーマンステスト結果 / SLA定義書 / 運用ガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードから直接確認可能
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ仕様がソースコードと一致しているか確認
- [ ] エラーハンドリングの記載が網羅的か確認
- [ ] 目標処理時間の妥当性を運用観点で確認
- [ ] 前後処理との関連が正確か確認
