---
generated_at: 2026-01-30 10:34:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-generate-sbom-prep-ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/generate-sbom-prep.ps1` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内コメント (7-8行目) - 1ESテンプレートとの互換性説明
- E-04: ソースコード内 Param ブロック (1-3行目) - パラメータ定義
- E-05: ソースコード内 $ArtifactName 変数定義 (9行目)
- E-06: ソースコード内 $SafeArtifactName 変数定義 (10行目)
- E-07: ソースコード内 `##vso[task.setvariable]` 出力 (29行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SBOM生成の前処理としてディレクトリ準備を行う | E-02, E-03 | ○ |
| C-02 | ManifestDirPathは必須パラメータ | E-04 | ○ |
| C-03 | SYSTEM_STAGENAMEとAGENT_JOBNAMEを組み合わせてアーティファクト名生成 | E-05 | ○ |
| C-04 | 特殊文字をアンダースコアに置換 | E-06 | ○ |
| C-05 | 1ESテンプレートとの互換性のためサブディレクトリを作成 | E-03 | ○ |
| C-06 | ディレクトリが存在しない場合New-Itemで作成 | E-01 (19-23行目) | ○ |
| C-07 | ディレクトリが既存の場合エラーメッセージを出力 | E-01 (24-26行目) | ○ |
| C-08 | Azure Pipelines変数としてARTIFACT_NAMEを設定 | E-07 | ○ |
| C-09 | pipeline-logging-functions.ps1を読み込む | E-01 (5行目) | ○ |
| C-10 | Join-PathでSBOMディレクトリパスを生成 | E-01 (11行目) | ○ |
| C-11 | 変換前後のアーティファクト名をログ出力 | E-01 (13-14行目) | ○ |
| C-12 | ディレクトリ作成時に成功メッセージを出力 | E-01 (22行目) | ○ |
| C-13 | Windows環境専用 | E-02 | ○ |
| C-14 | 置換対象は"/:<>\|?@*"()および空白 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 特殊文字の置換パターンがbash版と一致しているか確認
- [ ] Azure Pipelines変数の設定タイミングが適切か確認
- [ ] Linux/macOS版（generate-sbom-prep.sh）との整合性確認
