---
generated_at: 2026-01-30 10:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-vmr-sync

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/vmr-sync.sh` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内ヘッダーコメント (3-35行目) - スクリプト説明とオプション一覧
- E-04: ソースコード内引数解析部 (74-115行目) - パラメータ定義
- E-05: ソースコード内VMR準備部 (140-158行目) - VMRクローン・チェックアウト処理
- E-06: ソースコード内ツール初期化部 (164-169行目) - SDK・DARC初期化
- E-07: ソースコード内同期実行部 (191-207行目) - darc vmr forwardflow実行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 現在のリポジトリをVMRに同期する | E-02, E-03 | ○ |
| C-02 | --tmp-dirは必須パラメータ | E-03, E-04 (117-122行目) | ○ |
| C-03 | --vmr-dirのデフォルトは$tmp_dir/dotnet | E-04 (126-128行目) | ○ |
| C-04 | --branchでVMRブランチを指定可能 | E-03, E-04 (85-88行目) | ○ |
| C-05 | --remoteで追加リモートを指定可能 | E-03, E-04 (89-92行目) | ○ |
| C-06 | --azdev-patでプライベートリポジトリアクセス | E-03, E-04 (93-96行目) | ○ |
| C-07 | --debugでverbosityをdebugに設定 | E-04 (100-102行目) | ○ |
| C-08 | VMR未存在時はdotnet/dotnetをクローン | E-05 (140-147行目) | ○ |
| C-09 | 未コミット変更がある場合はエラー | E-05 (148-151行目) | ○ |
| C-10 | tools.shを読み込んでSDK初期化 | E-06 (165-166行目) | ○ |
| C-11 | GetDarcでDARCツールを取得 | E-06 (167行目) | ○ |
| C-12 | darc vmr forwardflowで同期実行 | E-07 (191-197行目) | ○ |
| C-13 | 同期成功時は"Synchronization succeeded"を出力 | E-07 (199-200行目) | ○ |
| C-14 | 同期失敗時はエラーメッセージとガイダンスを出力 | E-07 (201-206行目) | ○ |
| C-15 | --ciフラグでCI環境モードを設定 | E-04 (97-99行目) | ○ |
| C-16 | print_help関数でヘルプ表示 | E-01 (48-50, 103-106行目) | ○ |
| C-17 | カラー出力を使用（fail, highlight関数） | E-01 (52-64行目) | ○ |
| C-18 | DOTNET_ROOT環境変数を設定 | E-07 (189行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能
- ヘッダーコメントに詳細なドキュメントが含まれており、仕様理解が容易

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ仕様がヘッダーコメントと一致しているか確認
- [ ] エラーハンドリングの記載が網羅的か確認
- [ ] Windows版（vmr-sync.ps1）との整合性確認
