---
generated_at: 2026-01-30 10:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-vmr-sync-ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/vmr-sync.ps1` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内コメントブロック (1-35行目) - SYNOPSIS, DESCRIPTION, PARAMETER説明
- E-04: ソースコード内paramブロック (36-45行目) - パラメータ定義
- E-05: ソースコード内VMR準備部 (76-97行目) - VMRクローン・チェックアウト処理
- E-06: ソースコード内ツール初期化部 (103-107行目) - SDK・DARC初期化
- E-07: ソースコード内同期実行部 (112-138行目) - darc vmr forwardflow実行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 現在のリポジトリをVMRに同期する | E-02, E-03 | ○ |
| C-02 | -tmpDirは必須パラメータ | E-03, E-04 (37-38行目) | ○ |
| C-03 | -vmrDirのデフォルトは$tmpDir\dotnet | E-01 (68-70行目) | ○ |
| C-04 | -vmrBranchでVMRブランチを指定可能 | E-03, E-04 (39行目) | ○ |
| C-05 | -azdevPatでプライベートリポジトリアクセス | E-03, E-04 (41行目) | ○ |
| C-06 | -debugOutputでverbosityをdebugに設定 | E-01 (55-58行目) | ○ |
| C-07 | VMR未存在時はdotnet/dotnetをクローン | E-05 (78-85行目) | ○ |
| C-08 | 未コミット変更がある場合はエラー | E-05 (87-90行目) | ○ |
| C-09 | tools.ps1を読み込んでSDK初期化 | E-06 (104-105行目) | ○ |
| C-10 | Get-DarcでDARCツールを取得 | E-06 (106行目) | ○ |
| C-11 | darc vmr forwardflowで同期実行 | E-07 (112-127行目) | ○ |
| C-12 | LASTEXITCODEで成功/失敗判定 | E-07 (129行目) | ○ |
| C-13 | 同期成功時は"Synchronization succeeded"を出力 | E-07 (130行目) | ○ |
| C-14 | 同期失敗時はエラーメッセージとガイダンスを出力 | E-07 (132-137行目) | ○ |
| C-15 | -ciフラグでCI環境モードを設定 | E-04 (43行目), E-07 (119-121行目) | ○ |
| C-16 | Fail関数とHighlight関数でカラー出力 | E-01 (47-53行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能
- PowerShellコメントブロックに詳細なドキュメントが含まれており、仕様理解が容易

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ仕様がコメントブロックと一致しているか確認
- [ ] エラーハンドリングの記載が網羅的か確認
- [ ] bash版（vmr-sync.sh）との整合性確認
- [ ] Set-StrictModeの設定タイミングが適切か確認
