---
generated_at: 2026-01-30 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-pipeline-logging-functions

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/pipeline-logging-functions.sh` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内 Write-PipelineTelemetryError関数 (3-40行目)
- E-04: ソースコード内 Write-PipelineTaskError関数 (42-111行目)
- E-05: ソースコード内 Write-PipelineSetVariable関数 (113-161行目)
- E-06: ソースコード内 Write-PipelinePrependPath関数 (163-182行目)
- E-07: ソースコード内 Write-PipelineSetResult関数 (184-206行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Azure Pipelinesログコマンド形式で出力する | E-01, E-02 | ○ |
| C-02 | Write-PipelineTelemetryErrorはカテゴリ付きエラーを出力 | E-03 | ○ |
| C-03 | Write-PipelineTaskErrorはタスクエラーを出力 | E-04 | ○ |
| C-04 | Write-PipelineSetVariableはパイプライン変数を設定 | E-05 | ○ |
| C-05 | Write-PipelinePrependPathはPATHに追加 | E-06 | ○ |
| C-06 | Write-PipelineSetResultは実行結果を設定 | E-07 | ○ |
| C-07 | $ciがtrueでない場合は標準エラー出力 | E-03 (29-32行目), E-04 (84-87行目) | ○ |
| C-08 | -forceでCI環境以外でも強制出力 | E-03 (34-36行目), E-04 | ○ |
| C-09 | ##vso[task.logissue]形式で出力 | E-04 (89-110行目) | ○ |
| C-10 | ##vso[task.setvariable]形式で出力 | E-05 (154行目) | ○ |
| C-11 | ##vso[task.prependpath]形式で出力 | E-06 (180行目) | ○ |
| C-12 | ##vso[task.complete]形式で出力 | E-07 (204行目) | ○ |
| C-13 | セミコロンを%3Bにエスケープ | E-05 (149行目) | ○ |
| C-14 | 改行を%0D, %0Aにエスケープ | E-05 (150-151行目) | ○ |
| C-15 | ]を%5Dにエスケープ | E-05 (152行目) | ○ |
| C-16 | NETCORE_ENGINEERING_TELEMETRYカテゴリを付与 | E-03 (37行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各関数のパラメータ仕様が正確に記載されているか確認
- [ ] エスケープ処理の網羅性を確認
- [ ] Windows版（pipeline-logging-functions.ps1）との整合性確認
- [ ] $ci変数の判定ロジックが正確か確認
