---
generated_at: 2026-01-30 10:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-pipeline-logging-functions-ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/pipeline-logging-functions.ps1` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内コメント (1-2行目) - azure-pipelines-task-libからの派生
- E-04: ソースコード内 $loggingCommandEscapeMappings (6-11行目) - エスケープマッピング定義
- E-05: ソースコード内 Write-PipelineTelemetryError関数 (16-40行目)
- E-06: ソースコード内 Write-PipelineTaskError関数 (43-78行目)
- E-07: ソースコード内 Write-PipelineSetVariable関数 (80-97行目)
- E-08: ソースコード内 Write-PipelinePrependPath関数 (99-109行目)
- E-09: ソースコード内 Write-PipelineSetResult関数 (111-123行目)
- E-10: ソースコード内 Format-LoggingCommandData関数 (128-149行目)
- E-11: ソースコード内 Write-LogIssue関数 (218-260行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Azure Pipelinesログコマンド形式で出力する | E-01, E-02 | ○ |
| C-02 | azure-pipelines-task-libから派生したコード | E-03 | ○ |
| C-03 | Write-PipelineTelemetryErrorはカテゴリ付きエラーを出力 | E-05 | ○ |
| C-04 | Write-PipelineTaskErrorはタスクエラーを出力 | E-06 | ○ |
| C-05 | Write-PipelineSetVariableはパイプライン変数を設定 | E-07 | ○ |
| C-06 | Write-PipelinePrependPathはPATHに追加 | E-08 | ○ |
| C-07 | Write-PipelineSetResultは実行結果を設定 | E-09 | ○ |
| C-08 | 非CI環境ではerrorは赤色、warningは黄色で出力 | E-06 (59-67行目), E-11 (242-257行目) | ○ |
| C-09 | $ciがtrueでない場合は色付きWrite-Host | E-06 (58-67行目) | ○ |
| C-10 | -ForceでCI環境以外でも強制出力 | E-05, E-06 | ○ |
| C-11 | セミコロンを%3Bにエスケープ | E-04 | ○ |
| C-12 | 改行を%0D, %0Aにエスケープ | E-04 | ○ |
| C-13 | ]を%5Dにエスケープ | E-04 | ○ |
| C-14 | NETCORE_ENGINEERING_TELEMETRYカテゴリを付与 | E-05 (34-35行目) | ○ |
| C-15 | ValidateSetでResult値を検証 | E-09 (114行目) | ○ |
| C-16 | CmdletBindingで高度な関数機能を使用 | E-05, E-06, E-07等 | ○ |
| C-17 | IsMultiJobVariableのデフォルトは$true | E-07 (88行目) | ○ |
| C-18 | Format-LoggingCommandDataでエスケープ処理 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各関数のパラメータ仕様が正確に記載されているか確認
- [ ] エスケープマッピングの網羅性を確認
- [ ] bash版（pipeline-logging-functions.sh）との整合性確認
- [ ] ValidateSet値が正確に記載されているか確認
