---
generated_at: 2026-01-30 10:44:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-retain-build

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/retain-build.ps1` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内 Paramブロック (2-7行目) - パラメータ定義
- E-04: ソースコード内 Get-AzDOHeaders関数 (12-18行目) - 認証ヘッダー生成
- E-05: ソースコード内 Update-BuildRetention関数 (20-42行目) - ビルド保持更新処理
- E-06: ソースコード内 requestBody (27-29行目) - APIリクエストボディ
- E-07: ソースコード内 requestUri (31行目) - API URI構築

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Azure DevOpsのビルドを永久保持設定に更新する | E-02, E-05 | ○ |
| C-02 | buildIdは必須パラメータ（int型） | E-03 | ○ |
| C-03 | azdoOrgUriは必須パラメータ（string型） | E-03 | ○ |
| C-04 | azdoProjectは必須パラメータ（string型） | E-03 | ○ |
| C-05 | tokenは必須パラメータ（string型） | E-03 | ○ |
| C-06 | PATをBase64エンコードしてBasic認証ヘッダー作成 | E-04 | ○ |
| C-07 | リクエストボディはkeepForever: true | E-06 | ○ |
| C-08 | API URIはapi-version=6.0を使用 | E-07 | ○ |
| C-09 | Invoke-RestMethodでPATCHリクエスト | E-05 (35行目) | ○ |
| C-10 | 成功時は保持設定更新完了メッセージを出力 | E-05 (36行目) | ○ |
| C-11 | 失敗時はエラーメッセージ出力してexit 1 | E-05 (38-40行目) | ○ |
| C-12 | ErrorActionPreference = 'Stop'を設定 | E-01 (9行目) | ○ |
| C-13 | StrictMode Version 2.0を設定 | E-01 (10行目) | ○ |
| C-14 | スクリプト終了時はexit 0 | E-01 (45行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能
- 認証トークンのセキュアな取り扱いに注意

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ仕様が正確に記載されているか確認
- [ ] API URIのフォーマットが正確か確認
- [ ] エラーハンドリングの記載が網羅的か確認
- [ ] 認証方式の説明が正確か確認
