---
generated_at: 2026-01-30 10:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：89-generate-locproject

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **OneLocBuild Wikiリンクの有効性**：外部リンクの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/generate-locproject.ps1` - ソースコード本体
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: ソースコード内 Paramブロック (1-6行目) - パラメータ定義
- E-04: ソースコード内コメント (8-9行目) - OneLocBuild説明
- E-05: ソースコード内 除外リスト処理 (15-20行目)
- E-06: ソースコード内 JSONテンプレート検索 (26-32行目)
- E-07: ソースコード内 WXLファイル処理 (36-58行目)
- E-08: ソースコード内 XLFファイル処理 (69-84行目)
- E-09: ソースコード内 LocProject構築 (87-204行目)
- E-10: ソースコード内 比較処理 (214-226行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OneLocBuildタスク用のLocProject.jsonを生成 | E-02, E-04 | ○ |
| C-02 | SourcesDirectoryは必須パラメータ | E-03 | ○ |
| C-03 | LanguageSetのデフォルトはVS_Main_Languages | E-03 | ○ |
| C-04 | UseCheckedInLocProjectJsonで比較モード | E-03 | ○ |
| C-05 | CreateNeutralXlfsで中立XLF生成 | E-03 | ○ |
| C-06 | LocExclusions.jsonから除外リストを読み込む | E-05 | ○ |
| C-07 | .template.config\localize\*.en.jsonを検索 | E-06 | ○ |
| C-08 | en\strings.jsonパターンを検索 | E-01 (34行目) | ○ |
| C-09 | WXLファイルをスキーマでv3/v5に分類 | E-07 | ○ |
| C-10 | en.lproj\*.htmlを検索 | E-01 (60行目) | ○ |
| C-11 | *.\<langcode\>.xlfを検索 | E-08 | ○ |
| C-12 | JSON深さ5でシリアライズ | E-01 (206行目) | ○ |
| C-13 | 比較不一致時はexit 1 | E-10 (221行目) | ○ |
| C-14 | Get-FileHashで比較 | E-10 (218行目) | ○ |
| C-15 | LSSファイルでパーサ設定 | E-09 (127, 152, 177行目) | ○ |
| C-16 | CloneLanguageSetを設定 | E-09 (126, 151, 176行目) | ○ |
| C-17 | CopyOptionでLangIDOnName/LangIDOnPathを設定 | E-09 | ○ |
| C-18 | OneLocBuild Wikiリンクが有効 | **外部リンク** | △ |

## 4) 不足情報（Unknown / Missing）
- OneLocBuild Wikiリンク（https://ceapex.visualstudio.com/CEINTL/_wiki/wikis/CEINTL.wiki/107/）の有効性は外部確認が必要
  - 候補：内部ドキュメント / Microsoft社内Wiki

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードから直接確認可能
- 1: 中リスク - 外部リンクの有効性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ファイル検索パターンが正確に記載されているか確認
- [ ] LSSファイル名が正確か確認
- [ ] CloneLanguageSet値が正確か確認
- [ ] 除外リスト処理の説明が適切か確認
- [ ] 比較処理のロジックが正確に記載されているか確認
