---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：91-evaluate-changed-paths.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：実際のベンチマークデータなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/pipelines/evaluate-changed-paths.sh` 行1-214
- E-02: `eng/pipelines/evaluate-changed-paths.sh` 行2-22（シナリオ説明コメント）
- E-03: `eng/pipelines/evaluate-changed-paths.sh` 行34-46（usage関数）
- E-04: `eng/pipelines/evaluate-changed-paths.sh` 行69-104（引数解析）
- E-05: `eng/pipelines/evaluate-changed-paths.sh` 行111-116（customGitDiff関数）
- E-06: `eng/pipelines/evaluate-changed-paths.sh` 行141-211（probePaths関数）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行92

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CIでの変更検出によるビルドスキップ判定を行う | E-02, E-07 | ○ |
| C-02 | Azure DevOpsパイプラインと連携する | E-02, E-06 | ○ |
| C-03 | set -fでglobbingを無効化 | E-01 行25 | ○ |
| C-04 | set -uで未定義変数エラーを有効化 | E-01 行28 | ○ |
| C-05 | set -eでエラー時停止を有効化 | E-01 行32 | ○ |
| C-06 | --difftargetで比較対象を指定 | E-03, E-04 | ○ |
| C-07 | --excludepathsで除外パスを指定（+区切り） | E-03, E-04 行81-83 | ○ |
| C-08 | --includepathsで包含パスを指定（+区切り） | E-03, E-04 行85-88 | ○ |
| C-09 | --combinedで複合条件評価モード | E-02, E-04 行90-91 | ○ |
| C-10 | --subsetでサブセット名を指定 | E-04 行93-95 | ○ |
| C-11 | --azurevariableで出力変数名を指定 | E-04 行97-99 | ○ |
| C-12 | pipeline-logging-functions.shを読み込む | E-01 行107 | ○ |
| C-13 | git diffに-M -C -bオプションを使用 | E-05 行114 | ○ |
| C-14 | --ignore-cr-at-eol --ignore-space-at-eolオプションを使用 | E-05 行114 | ○ |
| C-15 | 除外パスは":!"形式で構築 | E-06 行154-155 | ○ |
| C-16 | 包含パスは":"形式で構築 | E-06 行167-168 | ○ |
| C-17 | combinedモードでは包含+除外パスで評価 | E-06 行174-182 | ○ |
| C-18 | 通常モードでは除外パス→包含パスの順で評価 | E-06 行184-200 | ○ |
| C-19 | 変更検出時にWrite-PipelineSetVariableを呼び出す | E-06 行206 | ○ |
| C-20 | --exit-codeオプションで変更有無を判定 | E-01 行128 | ○ |
| C-21 | マッチしたファイルをログ出力する | E-06 行181, 189, 198 | ○ |
| C-22 | 3つのシナリオ（exclude、include、combined）に対応 | E-02 | ○ |
| C-23 | PRの作成・更新時にトリガー | E-07 | ○ |
| C-24 | CoreCLR、Mono、Libraries等のサブセットに対応 | E-02, E-07 | ○ |
| C-25 | 目標処理時間は数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間「数秒以内」の根拠：実際のベンチマークデータや要件定義書がないため推測
  - 候補：CI/CDパイプラインのSLA定義 / 過去の実行ログ / パフォーマンス要件書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な技術仕様が大部分を占める

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認（CI/CD要件との整合性）
- [ ] Azure DevOps変数名の命名規則が実際のパイプライン定義と一致するか確認
- [ ] 3つのシナリオの説明がスクリプトコメントと一致するか確認
