---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：92-evaluate-changed-darc-deps.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：実際のベンチマークデータなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/pipelines/evaluate-changed-darc-deps.sh` 行1-99
- E-02: `eng/pipelines/evaluate-changed-darc-deps.sh` 行2-14（シナリオ説明コメント）
- E-03: `eng/pipelines/evaluate-changed-darc-deps.sh` 行26-34（usage関数）
- E-04: `eng/pipelines/evaluate-changed-darc-deps.sh` 行53-71（引数解析）
- E-05: `eng/pipelines/evaluate-changed-darc-deps.sh` 行73-77（difftarget検証）
- E-06: `eng/pipelines/evaluate-changed-darc-deps.sh` 行79-87（XML取得・比較）
- E-07: `eng/pipelines/evaluate-changed-darc-deps.sh` 行89-98（変数設定ループ）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行93

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DARC依存変更評価を行う | E-02, E-08 | ○ |
| C-02 | eng/Version.Details.xmlの変更を検出する | E-02, E-06 | ○ |
| C-03 | set -fでglobbingを無効化 | E-01 行17 | ○ |
| C-04 | set -uで未定義変数エラーを有効化 | E-01 行20 | ○ |
| C-05 | set -eでエラー時停止を有効化 | E-01 行24 | ○ |
| C-06 | --difftargetで比較対象を指定（必須） | E-03, E-04, E-05 | ○ |
| C-07 | --azurevariableprefixで出力変数のプレフィックスを指定 | E-03, E-04 行64-66 | ○ |
| C-08 | difftarget未指定時はusage表示して終了 | E-05 行73-77 | ○ |
| C-09 | mktempで一時ファイルを作成 | E-06 行79 | ○ |
| C-10 | pipeline-logging-functions.shを読み込む | E-01 行82 | ○ |
| C-11 | git showで旧Version.Details.xmlを取得 | E-06 行84 | ○ |
| C-12 | python3でget-changed-darc-deps.pyを実行 | E-06 行86 | ○ |
| C-13 | rm -fで一時ファイルを削除 | E-06 行87 | ○ |
| C-14 | プレフィックスがあれば末尾に"_"を追加 | E-07 行89-91 | ○ |
| C-15 | 依存関係名の"."を"_"に置換 | E-07 行94 | ○ |
| C-16 | 各依存関係に対してWrite-PipelineSetVariableを呼び出す | E-07 行96-97 | ○ |
| C-17 | バージョンまたはSHAが変更された依存関係を検出 | E-02 行5-6 | ○ |
| C-18 | 片方のXMLにのみ存在する依存関係を検出 | E-02 行7 | ○ |
| C-19 | YAML変数参照形式は dependencies.<JobName>.outputs... | E-02 行10 | ○ |
| C-20 | FIXMEコメントでエラー処理の課題を示唆 | E-06 行85 | ○ |
| C-21 | Maestroによる自動PRで利用される | E-08 | ○ |
| C-22 | 目標処理時間は数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間「数秒以内」の根拠：実際のベンチマークデータや要件定義書がないため推測
  - 候補：CI/CDパイプラインのSLA定義 / 過去の実行ログ / パフォーマンス要件書
- get-changed-darc-deps.pyの詳細仕様：Pythonスクリプトの内部実装は本設計書の範囲外

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - FIXMEコメントが示すエラー処理の不完全性
- 0: 低リスク - 基本的な技術仕様はソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認（CI/CD要件との整合性）
- [ ] get-changed-darc-deps.pyのエラーハンドリング状況を確認
- [ ] Azure DevOps変数名の命名規則（"."→"_"置換）が後続処理で正しく参照されるか確認
- [ ] Version.Details.xmlのスキーマ変更時の影響を確認
