---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：94-create-provisioning-profile.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：実際のベンチマークデータなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/performance/create-provisioning-profile.sh` 行1-107
- E-02: `eng/testing/performance/create-provisioning-profile.sh` 行3-6（初期設定）
- E-03: `eng/testing/performance/create-provisioning-profile.sh` 行11-21（OpenSSL設定）
- E-04: `eng/testing/performance/create-provisioning-profile.sh` 行23-25（証明書生成）
- E-05: `eng/testing/performance/create-provisioning-profile.sh` 行28-33（Keychain操作）
- E-06: `eng/testing/performance/create-provisioning-profile.sh` 行36-88（plistテンプレート）
- E-07: `eng/testing/performance/create-provisioning-profile.sh` 行91-95（UUID・証明書抽出）
- E-08: `eng/testing/performance/create-provisioning-profile.sh` 行98-106（mobileprovision生成・配置）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行95

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | iOSパフォーマンステスト用の証明書設定を行う | E-09 | ○ |
| C-02 | 自己署名コード署名証明書を生成 | E-03, E-04 | ○ |
| C-03 | set -exで全コマンドを出力、エラー時停止 | E-02 行3 | ○ |
| C-04 | CERT_COMMON_NAME="Apple Development: Self Sign" | E-02 行5 | ○ |
| C-05 | mktemp -dで一時フォルダを作成 | E-02 行6 | ○ |
| C-06 | extendedKeyUsage = 1.3.6.1.5.5.7.3.3（codeSigning） | E-03 行20 | ○ |
| C-07 | openssl genrsa -out selfsigncert.key 2048 | E-04 行23 | ○ |
| C-08 | openssl req -x509で自己署名証明書作成 | E-04 行24 | ○ |
| C-09 | openssl pkcs12 -exportで.p12ファイル作成 | E-04 行25 | ○ |
| C-10 | パスワードは"PLACEHOLDERselfsignpass" | E-04 行25, E-05 行29-32 | ○ |
| C-11 | security delete-keychain（|| trueで無視） | E-05 行28 | ○ |
| C-12 | security create-keychainで新規作成 | E-05 行29 | ○ |
| C-13 | security importで証明書インポート | E-05 行30 | ○ |
| C-14 | security set-key-partition-listを設定 | E-05 行31 | ○ |
| C-15 | security unlock-keychainでロック解除 | E-05 行32 | ○ |
| C-16 | security set-keychain-settingsでタイムアウト21600秒 | E-05 行33 | ○ |
| C-17 | plistにExpirationDate 2100-01-01を設定 | E-06 行67 | ○ |
| C-18 | TimeToLive 36500日を設定 | E-06 行80 | ○ |
| C-19 | uuidgenでUUIDを生成 | E-07 行91 | ○ |
| C-20 | sedでBEGIN/END CERTIFICATEを除去 | E-07 行92 | ○ |
| C-21 | plutil -replaceでUUIDを設定 | E-07 行94 | ○ |
| C-22 | plutil -replaceでDeveloperCertificatesを設定 | E-07 行95 | ○ |
| C-23 | security list-keychainsで検索パスに追加 | E-08 行98 | ○ |
| C-24 | security cms -Sで署名付きプロファイル作成 | E-08 行101 | ○ |
| C-25 | mkdir -pで出力ディレクトリ作成 | E-08 行104 | ○ |
| C-26 | 既存のSelfSign.mobileprovisionを削除 | E-08 行105 | ○ |
| C-27 | ~/Library/MobileDevice/Provisioning Profiles/にコピー | E-08 行106 | ○ |
| C-28 | 目標処理時間は30秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間「30秒以内」の根拠：実際のベンチマークデータや要件定義書がないため推測
  - 候補：CI/CDパイプラインのSLA定義 / 過去の実行ログ / パフォーマンス要件書
- Appleのプロビジョニングプロファイル仕様の詳細：Apple公式ドキュメントは本設計書の範囲外

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な技術仕様が大部分を占める
- 1: 中リスク - パスワードがハードコードされている（テスト用証明書のため許容）

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認（OpenSSL実行時間との整合性）
- [ ] ハードコードされたパスワードがセキュリティ要件を満たすか確認
- [ ] Keychainタイムアウト（6時間）がテストジョブ実行時間をカバーするか確認
- [ ] プロビジョニングプロファイルの有効期限設定が運用要件を満たすか確認
