---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：95-breaking-change-doc.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：実際のベンチマークデータなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/breakingChanges/breaking-change-doc.ps1` 行1-1232
- E-02: `eng/breakingChanges/breaking-change-doc.ps1` 行5-13（パラメータ定義）
- E-03: `eng/breakingChanges/breaking-change-doc.ps1` 行17-67（ヘルプ）
- E-04: `eng/breakingChanges/breaking-change-doc.ps1` 行72-78（config.ps1読み込み）
- E-05: `eng/breakingChanges/breaking-change-doc.ps1` 行100-168（前提条件検証）
- E-06: `eng/breakingChanges/breaking-change-doc.ps1` 行557-763（Invoke-LlmApi関数）
- E-07: `eng/breakingChanges/breaking-change-doc.ps1` 行765-952（Step 1: データ収集）
- E-08: `eng/breakingChanges/breaking-change-doc.ps1` 行954-1208（Step 2: ドキュメント生成）
- E-09: `eng/breakingChanges/config.ps1` 行1-32
- E-10: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行96

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 破壊的変更ドキュメントを自動生成する | E-03, E-10 | ○ |
| C-02 | LLMを使用してPR分析とドキュメント作成を行う | E-03, E-06 | ○ |
| C-03 | -CollectOnlyでデータ収集のみ実行 | E-02 行6 | ○ |
| C-04 | -CreateIssuesでGitHub Issue直接作成 | E-02 行7 | ○ |
| C-05 | -CommentでPRにコメント追加 | E-02 行8 | ○ |
| C-06 | -Cleanで前回データを削除 | E-02 行9, E-01 行181-188 | ○ |
| C-07 | -PrNumberで特定PR指定 | E-02 行10 | ○ |
| C-08 | -QueryでGitHub検索クエリ指定 | E-02 行11 | ○ |
| C-09 | -Helpでヘルプ表示 | E-02 行12, E-03 | ○ |
| C-10 | GitHub CLI認証を検証 | E-05 行102-118 | ○ |
| C-11 | config.ps1を読み込む | E-04 | ○ |
| C-12 | 5種類のLLMプロバイダーをサポート | E-06, E-09 行6 | ○ |
| C-13 | OpenAI APIをサポート | E-06 行665-692 | ○ |
| C-14 | Anthropic APIをサポート | E-06 行693-720 | ○ |
| C-15 | Azure OpenAI APIをサポート | E-06 行721-757 | ○ |
| C-16 | GitHub Modelsをサポート | E-06 行561-614, E-05 行131-143 | ○ |
| C-17 | GitHub Copilot CLIをサポート | E-06 行615-663, E-05 行144-157 | ○ |
| C-18 | powershell-yamlモジュールが必要（GitHub Models時） | E-01 行81-97 | ○ |
| C-19 | artifacts/docs/breakingChanges/配下に出力 | E-01 行173-179 | ○ |
| C-20 | PR詳細、コメント、レビュー、コミットを取得 | E-07 行793-798 | ○ |
| C-21 | Gitタグからバージョン情報を推定 | E-01 行465-553 | ○ |
| C-22 | Issueテンプレートを取得 | E-01 行284-297 | ○ |
| C-23 | 既存の破壊的変更Issueの例を取得 | E-01 行300-327 | ○ |
| C-24 | Limit-Text関数でテキスト長を制限（デフォルト2000文字） | E-01 行238-255 | ○ |
| C-25 | RateLimitingでAPI呼び出し間隔を制御 | E-09 行28-31, E-07 行905 | ○ |
| C-26 | DelayBetweenCallsは2秒 | E-09 行29 | ○ |
| C-27 | DelayBetweenIssuesは3秒 | E-09 行30 | ○ |
| C-28 | MaxPRsは100 | E-09 行18 | ○ |
| C-29 | IssueにはPri1、doc-ideaラベルが付与 | E-09 行22 | ○ |
| C-30 | breaking-changeラベルが付与 | E-09 行22 | ○ |
| C-31 | デフォルト担当者はgewarren | E-09 行23 | ○ |
| C-32 | dotnet/runtimeがSourceRepo | E-09 行13 | ○ |
| C-33 | dotnet/docsがDocsRepo | E-09 行14 | ○ |
| C-34 | -PrNumberと-Queryの同時指定はエラー | E-01 行213-216 | ○ |
| C-35 | PR1件あたり30秒〜2分の処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間「30秒〜2分」の根拠：LLM応答時間に依存するため実測データがない
  - 候補：LLMプロバイダー別のベンチマーク / 実行ログ分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な技術仕様が大部分を占める
- 1: 中リスク - LLM応答品質は設計書で保証できない

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認（LLMプロバイダー別）
- [ ] config.ps1のデフォルト設定が運用要件を満たすか確認
- [ ] LLM APIキーの管理方法がセキュリティ要件を満たすか確認
- [ ] 生成されるドキュメントの品質検証プロセスを確認
