---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：96-config.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/breakingChanges/config.ps1` 行1-32
- E-02: `eng/breakingChanges/config.ps1` 行4-11（LLM設定）
- E-03: `eng/breakingChanges/config.ps1` 行13-15（GitHub設定）
- E-04: `eng/breakingChanges/config.ps1` 行17-18（分析設定）
- E-05: `eng/breakingChanges/config.ps1` 行20-25（出力設定）
- E-06: `eng/breakingChanges/config.ps1` 行27-31（レート制限設定）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行97

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 破壊的変更ワークフローの設定ファイルである | E-01, E-07 | ○ |
| C-02 | $Config変数にHashtableを定義 | E-01 行3-32 | ○ |
| C-03 | LlmProvider = "github-models" | E-02 行6 | ○ |
| C-04 | LlmModel = "openai/gpt-4o" | E-02 行7 | ○ |
| C-05 | LlmApiKey = $null（デフォルト） | E-02 行8 | ○ |
| C-06 | LlmBaseUrl = $null（デフォルト） | E-02 行9 | ○ |
| C-07 | AzureApiVersion = "2024-02-15-preview" | E-02 行10 | ○ |
| C-08 | SourceRepo = "dotnet/runtime" | E-03 行13 | ○ |
| C-09 | DocsRepo = "dotnet/docs" | E-03 行14 | ○ |
| C-10 | IssueTemplatePath = ".github/ISSUE_TEMPLATE/02-breaking-change.yml" | E-03 行15 | ○ |
| C-11 | MaxPRs = 100 | E-04 行18 | ○ |
| C-12 | Labels = @("breaking-change", "Pri1", "doc-idea") | E-05 行22 | ○ |
| C-13 | Assignee = "gewarren" | E-05 行23 | ○ |
| C-14 | NotificationEmail = "dotnetbcn@microsoft.com" | E-05 行24 | ○ |
| C-15 | DelayBetweenCalls = 2 | E-06 行29 | ○ |
| C-16 | DelayBetweenIssues = 3 | E-06 行30 | ○ |
| C-17 | 5種類のLLMプロバイダーを選択可能 | E-02 行6（コメント参照） | ○ |
| C-18 | GitHub Modelsでは多数のモデル利用可能 | E-02 行7（コメント参照） | ○ |
| C-19 | Azure OpenAI使用時はLlmBaseUrl必須 | E-02 行9（コメント参照） | ○ |
| C-20 | 検出対象のAPIと例外設定を提供 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定ファイルのため全ての値がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトのLlmProviderとLlmModelが現在の要件を満たすか確認
- [ ] Assignee設定が最新の担当者と一致するか確認
- [ ] レート制限設定がAPI利用制限を遵守するか確認
