---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-getRefPackFolderFromSdk.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/native/ijw/getRefPackFolderFromSdk.ps1` 行1-30
- E-02: `eng/native/ijw/getRefPackFolderFromSdk.ps1` 行1-3（MITライセンス）
- E-03: `eng/native/ijw/getRefPackFolderFromSdk.ps1` 行4-6（パス算出）
- E-04: `eng/native/ijw/getRefPackFolderFromSdk.ps1` 行8-10（tools.ps1読み込み・SDK初期化）
- E-05: `eng/native/ijw/getRefPackFolderFromSdk.ps1` 行12-16（バージョン取得）
- E-06: `eng/native/ijw/getRefPackFolderFromSdk.ps1` 行18-28（パス検索・出力）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行99

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IJW用の参照アセンブリパスを解決する | E-07 | ○ |
| C-02 | SDK（インストール済み）から参照パックを取得 | E-04, E-05, E-07 | ○ |
| C-03 | $PSScriptRootからeng/native/ijwを特定 | E-03 行4 | ○ |
| C-04 | Split-Pathを3回使用してリポジトリルート算出 | E-03 行4-6 | ○ |
| C-05 | eng/common/tools.ps1をドットソースで読み込み | E-04 行8 | ○ |
| C-06 | InitializeDotNetCli $true $falseでSDK初期化 | E-04 行10 | ○ |
| C-07 | $GlobalJson.tools.dotnetでSDKバージョン取得 | E-05 行12 | ○ |
| C-08 | BundledVersions.propsパスを構築 | E-05 行14 | ○ |
| C-09 | Select-Xml -XPath "BundledNETCoreAppPackageVersion" | E-05 行16 | ○ |
| C-10 | Microsoft.NETCore.App.Ref packsパスを構築 | E-06 行19 | ○ |
| C-11 | Get-ChildItem -Recurse -Filter "System.Runtime.dll" | E-06 行20 | ○ |
| C-12 | Select-Object -First 1で最初の結果を取得 | E-06 行20 | ○ |
| C-13 | System.Runtime.dll不在時にWrite-Error | E-06 行24 | ○ |
| C-14 | System.Runtime.dll不在時にexit 1 | E-06 行25 | ○ |
| C-15 | エラーメッセージにSDK構造変更の確認を含む | E-06 行24 | ○ |
| C-16 | Split-Pathで親ディレクトリを取得 | E-06 行28 | ○ |
| C-17 | Write-Outputで"refPackPath=$refPackPath"を出力 | E-06 行30 | ○ |
| C-18 | FrameworkList.xmlを読まずにSystem.Runtime.dllで検索 | E-06 行18（コメント） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 短いスクリプトで全ての処理がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SDKのパック構造が変更されていないか確認
- [ ] BundledNETCoreAppPackageVersionのXPath式が現在のスキーマと一致するか確認
- [ ] getRefPackFolderFromArtifacts.ps1との役割分担が適切か確認
- [ ] InitializeDotNetCliの戻り値（$dotnetRoot）が期待通りか確認
