---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：99-extract-for-crossdac.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/extract-for-crossdac.ps1` 行1-25
- E-02: `eng/extract-for-crossdac.ps1` 行1-9（パラメータ定義）
- E-03: `eng/extract-for-crossdac.ps1` 行11（圧縮ライブラリ読み込み）
- E-04: `eng/extract-for-crossdac.ps1` 行13-14（検索開始）
- E-05: `eng/extract-for-crossdac.ps1` 行15-25（パッケージ処理ループ）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行100

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クロスDACコンポーネントを抽出する | E-06 | ○ |
| C-02 | クロスプラットフォームデバッグ用である | E-06 | ○ |
| C-03 | CmdletBindingが指定されている | E-02 行1 | ○ |
| C-04 | -DownloadDirectoryは必須パラメータ | E-02 行3-4 | ○ |
| C-05 | -ExtractDirectoryは必須パラメータ | E-02 行6-7 | ○ |
| C-06 | Add-Type -Assembly 'System.IO.Compression.FileSystem' | E-03 行11 | ○ |
| C-07 | Get-ChildItem -Recurse -Filter '*.nupkg' | E-04 行15 | ○ |
| C-08 | 正規表現でLinuxランタイムパッケージを識別 | E-05 行17 | ○ |
| C-09 | 対象: Microsoft.NETCore.App.Runtime.linux(-musl)?-* | E-05 行17 | ○ |
| C-10 | $matches['id']でパッケージIDを取得 | E-05 行18 | ○ |
| C-11 | $matches['ver']でバージョンを取得 | E-05 行19 | ○ |
| C-12 | $id.ToLowerInvariant()で小文字化 | E-05 行20 | ○ |
| C-13 | ZipFile.ExtractToDirectoryで展開 | E-05 行21 | ○ |
| C-14 | 非マッチ時に"Skipping non-runtime pack"を出力 | E-05 行23 | ○ |
| C-15 | "Looking for packages under"をログ出力 | E-04 行13 | ○ |
| C-16 | "Found Package:"をログ出力 | E-05 行16 | ○ |
| C-17 | "Extracting Package:"をログ出力 | E-05 行20 | ○ |
| C-18 | 抽出先は{ExtractDirectory}/{id.lowercase}/{version} | E-05 行20-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 短いスクリプトで全ての処理がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 対象パッケージパターンが現在のLinuxランタイムパッケージ名と一致するか確認
- [ ] 抽出先ディレクトリ構造がクロスDACビルドの期待と一致するか確認
- [ ] 新しいLinuxアーキテクチャが追加された場合にパターン更新が必要か確認
